"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCustomEvaluator = void 0;
var _prompts = require("@langchain/core/prompts");
var _evaluation = require("langchain/evaluation");
var _get_example_attack_discoveries_with_replacements = require("./get_example_attack_discoveries_with_replacements");
var _get_run_attack_discoveries_with_replacements = require("./get_run_attack_discoveries_with_replacements");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCustomEvaluator = ({
  criteria,
  key,
  llm,
  template
}) => async (rootRun, example) => {
  const chain = await (0, _evaluation.loadEvaluator)('labeled_criteria', {
    criteria,
    chainOptions: {
      prompt: _prompts.PromptTemplate.fromTemplate(template)
    },
    llm
  });
  const exampleAttackDiscoveriesWithReplacements = (0, _get_example_attack_discoveries_with_replacements.getExampleAttackDiscoveriesWithReplacements)(example);
  const runAttackDiscoveriesWithReplacements = (0, _get_run_attack_discoveries_with_replacements.getRunAttackDiscoveriesWithReplacements)(rootRun);

  // NOTE: res contains a score, as well as the reasoning for the score
  const res = await chain.evaluateStrings({
    input: '',
    // empty for now, but this could be the alerts, i.e. JSON.stringify(rootRun.outputs?.anonymizedAlerts, null, 2),
    prediction: JSON.stringify(runAttackDiscoveriesWithReplacements, null, 2),
    reference: JSON.stringify(exampleAttackDiscoveriesWithReplacements, null, 2)
  });
  return {
    key,
    score: res.score
  };
};
exports.getCustomEvaluator = getCustomEvaluator;