"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.typedInterrupt = void 0;
var _schemas = require("../schemas");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Light wrapper around the `interrupt` helper method from @langchain/langgraph.
 * Ensures the correct types are used for interrupt values and resume values so that
 * the interrupts are rendered correctly on the frontend.
 */
const typedInterrupt = async interruptValue => {
  if (typeof window !== 'undefined') {
    throw new Error('typedInterrupt is only available on the server side');
  }
  const {
    interrupt
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@langchain/langgraph'))); // Ensures this is only imported server side.

  const result = interrupt(interruptValue);
  const parsedResult = _schemas.InterruptResumeValue.safeParse(result);
  if (!parsedResult.success) {
    throw new Error(`Resume value did not match schema: ${JSON.stringify(parsedResult.error)}`);
  }
  if (parsedResult.data.type !== interruptValue.type) {
    throw new Error(`Resume value type mismatch: expected ${interruptValue.type}, got ${parsedResult.data.type}`);
  }
  return parsedResult.data;
};
exports.typedInterrupt = typedInterrupt;