"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkIndicesPrivileges = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks user has the required privileges to do a results check for the given indices.
 * In order to be allowed to do a result check user needs:
 * `read`, `view_index_metadata` and (`monitor` or `manage`) index privileges.
 */
const checkIndicesPrivileges = async ({
  client,
  indices
}) => {
  const privileges = await client.asCurrentUser.security.hasPrivileges({
    index: [{
      names: indices,
      privileges: ['read', 'view_index_metadata', 'monitor', 'manage']
    }]
  });
  const hasRequiredIndexPrivilege = {};
  Object.entries(privileges.index).forEach(([indexName, {
    read,
    view_index_metadata: viewMetadata,
    monitor,
    manage
  }]) => {
    hasRequiredIndexPrivilege[indexName] = read && viewMetadata && (monitor || manage);
  });
  return hasRequiredIndexPrivilege;
};
exports.checkIndicesPrivileges = checkIndicesPrivileges;