"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALL_RECOMMENDED_FIELDS_FOR_ESQL = void 0;
var _default_logs = require("./default_logs");
var _apache_error_logs = require("./apache_error_logs");
var _kubernetes_container_logs = require("./kubernetes_container_logs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Merged list of all recommended fields for ES|QL autocomplete.
 */
const ALL_RECOMMENDED_FIELDS_FOR_ESQL = exports.ALL_RECOMMENDED_FIELDS_FOR_ESQL = [..._apache_error_logs.APACHE_ERROR_LOGS_PROFILE.recommendedFields.map(name => ({
  name,
  pattern: `${_apache_error_logs.APACHE_ERROR_LOGS_PROFILE.pattern}*`
})), ..._kubernetes_container_logs.KUBERNETES_CONTAINER_LOGS_PROFILE.recommendedFields.map(name => ({
  name,
  pattern: `${_kubernetes_container_logs.KUBERNETES_CONTAINER_LOGS_PROFILE.pattern}*`
})), ..._default_logs.DEFAULT_LOGS_PROFILE.recommendedFields.map(name => ({
  name,
  pattern: `${_default_logs.DEFAULT_LOGS_PROFILE.pattern}*`
}))];