"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverGridFlyoutActions = DiscoverGridFlyoutActions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/components/discover_grid_flyout/discover_grid_flyout_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_VISIBLE_ACTIONS_BEFORE_THE_FOLD = 3;
function DiscoverGridFlyoutActions({
  flyoutActions
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [ref, setRef] = (0, _react.useState)(null);
  const dimensions = (0, _eui.useResizeObserver)(ref);
  const isMobileScreen = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const isLargeFlyout = dimensions !== null && dimensions !== void 0 && dimensions.width ? dimensions.width > euiTheme.base * 30 : false;
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: setRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FlyoutActions, {
    flyoutActions: flyoutActions,
    isMobileScreen: isMobileScreen,
    isLargeFlyout: isLargeFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
}
function FlyoutActions({
  flyoutActions,
  isMobileScreen,
  isLargeFlyout
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isMoreFlyoutActionsPopoverOpen, setIsMoreFlyoutActionsPopoverOpen] = (0, _react.useState)(false);
  if (isMobileScreen) {
    return /*#__PURE__*/_react.default.createElement(FlyoutActionsPopover, {
      flyoutActions: flyoutActions,
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        iconSize: "s",
        iconType: "arrowDown",
        iconSide: "right",
        flush: "left",
        "data-test-subj": "docViewerMobileActionsButton",
        onClick: () => setIsMoreFlyoutActionsPopoverOpen(!isMoreFlyoutActionsPopoverOpen),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('discover.grid.tableRow.mobileFlyoutActionsButton', {
        defaultMessage: 'Actions'
      })),
      isOpen: isMoreFlyoutActionsPopoverOpen,
      closePopover: () => setIsMoreFlyoutActionsPopoverOpen(false),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    });
  }
  const visibleFlyoutActions = (0, _lodash.slice)(flyoutActions, 0, MAX_VISIBLE_ACTIONS_BEFORE_THE_FOLD);
  const remainingFlyoutActions = (0, _lodash.slice)(flyoutActions, MAX_VISIBLE_ACTIONS_BEFORE_THE_FOLD, flyoutActions.length);
  const showFlyoutIconsOnly = remainingFlyoutActions.length > 0 || !isLargeFlyout && visibleFlyoutActions.length > 1;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    alignItems: "center",
    gutterSize: "none",
    "data-test-subj": "docViewerFlyoutActions",
    css: showFlyoutIconsOnly ? undefined : (0, _react2.css)`
              gap: ${euiTheme.base / 4 * 3}px;
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('discover.grid.tableRow.actionsLabel', {
    defaultMessage: 'Actions'
  }), ":")), visibleFlyoutActions.map(action => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: action.id,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, showFlyoutIconsOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: action.helpText ? `${action.label} - ${action.helpText}` : action.label,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    iconType: action.iconType,
    "data-test-subj": action.dataTestSubj,
    "aria-label": action.label,
    href: action.href,
    onClick: action.onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: action.helpText,
    delay: "long",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconSize: "s",
    flush: "both",
    iconType: action.iconType,
    "data-test-subj": action.dataTestSubj,
    href: action.href,
    onClick: action.onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }, action.label)))), remainingFlyoutActions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(FlyoutActionsPopover, {
    flyoutActions: remainingFlyoutActions,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('discover.grid.tableRow.moreFlyoutActionsButton', {
        defaultMessage: 'More actions'
      }),
      disableScreenReaderOutput: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      iconType: "boxesVertical",
      "data-test-subj": "docViewerMoreFlyoutActionsButton",
      "aria-label": _i18n.i18n.translate('discover.grid.tableRow.moreFlyoutActionsButton', {
        defaultMessage: 'More actions'
      }),
      onClick: () => setIsMoreFlyoutActionsPopoverOpen(!isMoreFlyoutActionsPopoverOpen),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 17
      }
    })),
    isOpen: isMoreFlyoutActionsPopoverOpen,
    closePopover: () => setIsMoreFlyoutActionsPopoverOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  })));
}
function FlyoutActionsPopover({
  flyoutActions,
  button,
  isOpen,
  closePopover
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "docViewerMoreFlyoutActions",
    button: button,
    isOpen: isOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: flyoutActions.map(action => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: action.id,
      icon: action.iconType,
      "data-test-subj": action.dataTestSubj,
      href: action.href,
      onClick: action.onClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 11
      }
    }, action.label)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }));
}