"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEsqlSource = exports.isDataViewSource = exports.isDataSourceType = exports.createEsqlDataSource = exports.createDataViewDataSource = exports.createDataSource = void 0;
var _esQuery = require("@kbn/es-query");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createDataViewDataSource = ({
  dataViewId
}) => ({
  type: _types.DataSourceType.DataView,
  dataViewId
});
exports.createDataViewDataSource = createDataViewDataSource;
const createEsqlDataSource = () => ({
  type: _types.DataSourceType.Esql
});
exports.createEsqlDataSource = createEsqlDataSource;
const createDataSource = ({
  dataView,
  query
}) => {
  if ((0, _esQuery.isOfAggregateQueryType)(query)) {
    return createEsqlDataSource();
  }
  if (typeof dataView === 'string') {
    return createDataViewDataSource({
      dataViewId: dataView
    });
  }
  if (dataView !== null && dataView !== void 0 && dataView.id) {
    return createDataViewDataSource({
      dataViewId: dataView.id
    });
  }
  return undefined;
};
exports.createDataSource = createDataSource;
const isDataSourceType = (dataSource, type) => (dataSource === null || dataSource === void 0 ? void 0 : dataSource.type) === type;
exports.isDataSourceType = isDataSourceType;
const isDataViewSource = dataSource => isDataSourceType(dataSource, _types.DataSourceType.DataView);
exports.isDataViewSource = isDataViewSource;
const isEsqlSource = dataSource => isDataSourceType(dataSource, _types.DataSourceType.Esql);
exports.isEsqlSource = isEsqlSource;