"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DatasetQualityError extends Error {
  constructor(message, originalError) {
    super(message);
    (0, _defineProperty2.default)(this, "statusCode", void 0);
    (0, _defineProperty2.default)(this, "originalMessage", void 0);
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'DatasetQualityError';
    if (originalError && originalError.body) {
      const {
        statusCode,
        message: originalMessage
      } = originalError.body;
      this.statusCode = statusCode;
      this.originalMessage = originalMessage;
    }
  }
}
exports.DatasetQualityError = DatasetQualityError;