"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataComparisonChartTooltipBody = void 0;
var _charts = require("@elastic/charts");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/field-formats-plugin/common");
var _default_value_formatter = require("./charts/default_value_formatter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/data_drift/data_drift_chart_tooltip_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const style = {
  textAlign: 'right'
};
const DataComparisonChartTooltipBody = ({
  items
}) => {
  const percentFormatter = (0, _default_value_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.PERCENT);
  const footer = items.length > 1 ? /*#__PURE__*/_react.default.createElement(_charts.TooltipTableFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableColorCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 12
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 11
    }
  }, "Diff"), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 11
    }
  }, items[1].datum.doc_count - items[0].datum.doc_count), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }, percentFormatter(items[1].datum.percentage - items[0].datum.percentage)))) : null;
  return /*#__PURE__*/_react.default.createElement(_charts.TooltipTable, {
    gridTemplateColumns: `repeat(${4}, auto)`,
    maxHeight: 120,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableColorCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 12
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, "Count"), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, "Percent"))), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, items.map(({
    label,
    datum,
    seriesIdentifier: {
      key
    },
    color
  }) => /*#__PURE__*/_react.default.createElement(_charts.TooltipTableRow, {
    key: `${key}-${datum.x}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableColorCell, {
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 14
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  }, label), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, datum.doc_count), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, percentFormatter(datum.percentage))))), footer);
};
exports.DataComparisonChartTooltipBody = DataComparisonChartTooltipBody;