"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _samples = require("../../samples");
var _default = require("../default/default");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_format_editor/editors/url/url.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class UrlFormatEditor extends _default.DefaultFormatEditor {
  get sampleIconPath() {
    var _this$context;
    const sampleIconPath = `/plugins/dataViewFieldEditor/assets/icons/{{value}}.png`;
    return (_this$context = this.context) !== null && _this$context !== void 0 && _this$context.services.http ? this.context.services.http.basePath.prepend(sampleIconPath) : sampleIconPath;
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "sanitizeNumericValue", val => {
      const sanitizedValue = parseInt(val, 10);
      if (isNaN(sanitizedValue)) {
        return '';
      }
      return sanitizedValue;
    });
    (0, _defineProperty2.default)(this, "onTypeChange", newType => {
      const {
        urlTemplate,
        width,
        height
      } = this.props.formatParams;
      const params = {
        type: newType
      };
      if (newType === 'img') {
        params.width = width;
        params.height = height;
        if (!urlTemplate) {
          params.urlTemplate = this.sampleIconPath;
        }
      } else if (newType !== 'img' && urlTemplate === this.sampleIconPath) {
        params.urlTemplate = undefined;
      }
      this.onChange(params);
    });
    (0, _defineProperty2.default)(this, "renderWidthHeightParameters", () => {
      const width = this.sanitizeNumericValue(this.props.formatParams.width);
      const height = this.sanitizeNumericValue(this.props.formatParams.height);
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "indexPatternFieldEditor.url.widthLabel",
          defaultMessage: "Width",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 13
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        "data-test-subj": "urlEditorWidth",
        value: width,
        onChange: e => {
          this.onChange({
            width: e.target.value
          });
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 11
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "indexPatternFieldEditor.url.heightLabel",
          defaultMessage: "Height",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 13
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        "data-test-subj": "urlEditorHeight",
        value: height,
        onChange: e => {
          this.onChange({
            height: e.target.value
          });
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 11
        }
      })));
    });
    this.state = {
      ...this.state,
      sampleInputsByType: {
        a: ['john', '/some/pathname/asset.png', 1234],
        img: ['go', 'stop', ['de', 'ne', 'us', 'ni'], 'cv'],
        audio: ['hello.mp3']
      },
      sampleConverterType: 'html',
      showUrlTemplateHelp: false,
      showLabelTemplateHelp: false
    };
  }
  render() {
    var _formatParams$type, _this$context$service, _this$context$service2;
    const {
      formatParams,
      format
    } = this.props;
    const {
      error,
      samples,
      sampleConverterType
    } = this.state;
    const urlType = (_formatParams$type = formatParams.type) !== null && _formatParams$type !== void 0 ? _formatParams$type : `${format.getParamDefaults().type}`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.typeLabel",
        defaultMessage: "Type",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 13
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "urlEditorType",
      value: urlType,
      options: format.type.urlTypes.map(type => {
        return {
          value: type.kind,
          text: type.text
        };
      }),
      onChange: e => {
        this.onTypeChange(e.target.value);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 11
      }
    })), urlType === 'a' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.openTabLabel",
        defaultMessage: "Open in a new tab",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: formatParams.openLinkInCurrentTab ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.offLabel",
        defaultMessage: "Off",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 19
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.onLabel",
        defaultMessage: "On",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 19
        }
      }),
      checked: !formatParams.openLinkInCurrentTab,
      onChange: e => {
        this.onChange({
          openLinkInCurrentTab: !e.target.checked
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 13
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.urlTemplateLabel",
        defaultMessage: "URL template",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 13
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: (_this$context$service = this.context.services.docLinks) === null || _this$context$service === void 0 ? void 0 : _this$context$service.links.indexPatterns.fieldFormattersString,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.template.helpLinkText",
        defaultMessage: "URL template help",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 15
        }
      })),
      isInvalid: !!error,
      error: error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: !!error,
      "data-test-subj": "urlEditorUrlTemplate",
      value: formatParams.urlTemplate || '',
      onChange: e => {
        this.onChange({
          urlTemplate: e.target.value
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.labelTemplateLabel",
        defaultMessage: "Label template",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 238,
          columnNumber: 13
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: (_this$context$service2 = this.context.services.docLinks) === null || _this$context$service2 === void 0 ? void 0 : _this$context$service2.links.indexPatterns.fieldFormattersString,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 244,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.labelTemplateHelpText",
        defaultMessage: "Label template help",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 248,
          columnNumber: 15
        }
      })),
      isInvalid: !!error,
      error: error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: !!error,
      "data-test-subj": "urlEditorLabelTemplate",
      value: formatParams.labelTemplate || '',
      onChange: e => {
        this.onChange({
          labelTemplate: e.target.value
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 11
      }
    })), urlType === 'img' && this.renderWidthHeightParameters(), /*#__PURE__*/_react.default.createElement(_samples.FormatEditorSamples, {
      samples: samples,
      sampleType: sampleConverterType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 9
      }
    }));
  }
}
exports.UrlFormatEditor = UrlFormatEditor;
(0, _defineProperty2.default)(UrlFormatEditor, "contextType", _public.context);
(0, _defineProperty2.default)(UrlFormatEditor, "formatId", _constants.formatId);