"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toEqlKibanaSearchResponse = toEqlKibanaSearchResponse;
var _sanitize_request_params = require("../../sanitize_request_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Get the Kibana representation of an EQL search response (see `IKibanaSearchResponse`).
 * (EQL does not provide _shard info, so total/loaded cannot be calculated.)
 */
function toEqlKibanaSearchResponse(response, requestParams) {
  return {
    id: response.body.id,
    rawResponse: response.body,
    isPartial: response.body.is_partial,
    isRunning: response.body.is_running,
    ...(requestParams ? {
      requestParams: (0, _sanitize_request_params.sanitizeRequestParams)(requestParams)
    } : {})
  };
}