"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardSearchOptionsSchema = void 0;
exports.getDashboardSearchResultsSchema = getDashboardSearchResultsSchema;
var _configSchema = require("@kbn/config-schema");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDashboardSearchResultsSchema() {
  const {
    title: titleSchema,
    description: descriptionSchema,
    tags: tagsSchema
  } = (0, _common.getDashboardStateSchema)();
  return (0, _common.getDashboardAPIItemSchema)().extends({
    attributes: _configSchema.schema.object({
      title: titleSchema,
      description: descriptionSchema,
      tags: tagsSchema
    })
  });
}
const dashboardSearchOptionsSchema = exports.dashboardSearchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  includeReferences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('tag')]))),
  kuery: _configSchema.schema.maybe(_configSchema.schema.string()),
  cursor: _configSchema.schema.maybe(_configSchema.schema.number()),
  limit: _configSchema.schema.maybe(_configSchema.schema.number()),
  spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    meta: {
      description: 'An array of spaces to search or "*" to search all spaces. Defaults to the current space if not specified.'
    }
  }))
}, {
  unknowns: 'forbid'
}));