"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSessionRestorationDataProvider = createSessionRestorationDataProvider;
exports.removeSearchSessionIdFromURL = exports.getSessionURLObservable = exports.getSearchSessionIdFromURL = void 0;
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _common = require("@kbn/kibana-utils-plugin/common");
var _public = require("@kbn/kibana-utils-plugin/public");
var _rxjs = require("rxjs");
var _constants = require("../../../common/constants");
var _kibana_services = require("../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const removeSearchSessionIdFromURL = kbnUrlStateStorage => {
  kbnUrlStateStorage.kbnUrlControls.updateAsync(nextUrl => {
    if (nextUrl.includes(_constants.SEARCH_SESSION_ID)) {
      return (0, _common.replaceUrlHashQuery)(nextUrl, hashQuery => {
        delete hashQuery[_constants.SEARCH_SESSION_ID];
        return hashQuery;
      });
    }
    return nextUrl;
  });
};
exports.removeSearchSessionIdFromURL = removeSearchSessionIdFromURL;
const getSearchSessionIdFromURL = history => (0, _public.getQueryParams)(history.location)[_constants.SEARCH_SESSION_ID];
exports.getSearchSessionIdFromURL = getSearchSessionIdFromURL;
const getSessionURLObservable = history => (0, _public.createQueryParamObservable)(history, _constants.SEARCH_SESSION_ID).pipe((0, _rxjs.map)(sessionId => sessionId !== null && sessionId !== void 0 ? sessionId : undefined));
exports.getSessionURLObservable = getSessionURLObservable;
function createSessionRestorationDataProvider(dashboardApi, dashboardInternalApi) {
  return {
    getName: async () => {
      var _ref, _dashboardApi$title$$;
      return (_ref = (_dashboardApi$title$$ = dashboardApi.title$.value) !== null && _dashboardApi$title$$ !== void 0 ? _dashboardApi$title$$ : dashboardApi.savedObjectId$.value) !== null && _ref !== void 0 ? _ref : dashboardApi.uuid;
    },
    getLocatorData: async () => ({
      id: _deeplinksAnalytics.DASHBOARD_APP_LOCATOR,
      initialState: getLocatorParams({
        dashboardApi,
        dashboardInternalApi,
        shouldRestoreSearchSession: false
      }),
      restoreState: getLocatorParams({
        dashboardApi,
        dashboardInternalApi,
        shouldRestoreSearchSession: true
      })
    })
  };
}

/**
 * Fetches the state to store when a session is saved so that this dashboard can be recreated exactly
 * as it was.
 */
function getLocatorParams({
  dashboardApi,
  dashboardInternalApi,
  shouldRestoreSearchSession
}) {
  var _panels$references, _dashboardApi$viewMod;
  const savedObjectId = dashboardApi.savedObjectId$.value;
  const panels = savedObjectId ? dashboardInternalApi.serializeLayout() : undefined;
  const {
    controlGroupInput,
    controlGroupReferences
  } = dashboardInternalApi.serializeControls();
  const combinedReferences = [...((_panels$references = panels === null || panels === void 0 ? void 0 : panels.references) !== null && _panels$references !== void 0 ? _panels$references : []), ...(controlGroupReferences !== null && controlGroupReferences !== void 0 ? controlGroupReferences : [])];
  return {
    viewMode: (_dashboardApi$viewMod = dashboardApi.viewMode$.value) !== null && _dashboardApi$viewMod !== void 0 ? _dashboardApi$viewMod : 'view',
    useHash: false,
    preserveSavedFilters: false,
    filters: _kibana_services.dataService.query.filterManager.getFilters(),
    query: _kibana_services.dataService.query.queryString.formatQuery(dashboardApi.query$.value),
    dashboardId: savedObjectId,
    searchSessionId: shouldRestoreSearchSession ? _kibana_services.dataService.search.session.getSessionId() : undefined,
    timeRange: shouldRestoreSearchSession ? _kibana_services.dataService.query.timefilter.timefilter.getAbsoluteTime() : _kibana_services.dataService.query.timefilter.timefilter.getTime(),
    refreshInterval: shouldRestoreSearchSession ? {
      pause: true,
      // force pause refresh interval when restoring a session
      value: 0
    } : undefined,
    controlGroupInput,
    panels: panels === null || panels === void 0 ? void 0 : panels.panels,
    references: combinedReferences
  };
}