"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeLayout = serializeLayout;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function serializeLayout(layout, childState) {
  const sections = {};
  Object.entries(layout.sections).forEach(([sectionId, sectionState]) => {
    sections[sectionId] = {
      ...sectionState,
      uid: sectionId,
      panels: []
    };
  });
  const references = [];
  const panels = [];
  Object.entries(layout.panels).forEach(([panelId, {
    grid,
    type
  }]) => {
    var _childState$panelId$r, _childState$panelId, _childState$panelId$r2, _childState$panelId2;
    const config = (_childState$panelId$r = (_childState$panelId = childState[panelId]) === null || _childState$panelId === void 0 ? void 0 : _childState$panelId.rawState) !== null && _childState$panelId$r !== void 0 ? _childState$panelId$r : {};
    references.push(...(0, _common.prefixReferencesFromPanel)(panelId, (_childState$panelId$r2 = (_childState$panelId2 = childState[panelId]) === null || _childState$panelId2 === void 0 ? void 0 : _childState$panelId2.references) !== null && _childState$panelId$r2 !== void 0 ? _childState$panelId$r2 : []));
    const {
      sectionId,
      ...restOfGridData
    } = grid; // drop section ID
    const panelState = {
      type,
      grid: restOfGridData,
      uid: panelId,
      config
    };
    if (sectionId) {
      sections[sectionId].panels.push(panelState);
    } else {
      panels.push(panelState);
    }
  });
  return {
    panels: [...panels, ...Object.values(sections)],
    references
  };
}