"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.objectToArray = exports.arrayToObject = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const objectToArray = obj => Object.keys(obj).map(k => ({
  ...obj[k],
  __id__: k
}));
exports.objectToArray = objectToArray;
const arrayToObject = (array, keyProp = 'id') => array.reduce((acc, item) => {
  acc[item[keyProp]] = item;
  return acc;
}, {});
exports.arrayToObject = arrayToObject;