"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTypeRegistries = void 0;
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Create the 'before' and 'after' type registries from the provided testkit type definitions.
 */
const getTypeRegistries = ({
  types,
  kibanaIndex
}) => {
  const registryBefore = new _coreSavedObjectsBaseServerInternal.SavedObjectTypeRegistry();
  const registryAfter = new _coreSavedObjectsBaseServerInternal.SavedObjectTypeRegistry();
  for (const definition of types) {
    const {
      typeBefore,
      typeAfter
    } = getTypes({
      definition,
      kibanaIndex
    });
    registryBefore.registerType(typeBefore);
    registryAfter.registerType(typeAfter);
  }
  return {
    registryBefore,
    registryAfter
  };
};
exports.getTypeRegistries = getTypeRegistries;
const getTypes = ({
  definition,
  kibanaIndex
}) => {
  var _definition$definitio;
  const modelVersionMap = typeof definition.definition.modelVersions === 'function' ? definition.definition.modelVersions() : (_definition$definitio = definition.definition.modelVersions) !== null && _definition$definitio !== void 0 ? _definition$definitio : {};
  const typeBefore = {
    ...definition.definition,
    indexPattern: kibanaIndex,
    modelVersions: removeKeysGreaterThan(modelVersionMap, definition.modelVersionBefore)
  };
  const typeAfter = {
    ...definition.definition,
    indexPattern: kibanaIndex,
    modelVersions: removeKeysGreaterThan(modelVersionMap, definition.modelVersionAfter)
  };
  return {
    typeBefore,
    typeAfter
  };
};
const removeKeysGreaterThan = (record, version) => {
  return Object.fromEntries(Object.entries(record).filter(([key, value]) => {
    return parseInt(key, 10) <= version;
  }));
};