"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unwindNestedSecurityPrivileges = exports.AuthzOptOutReason = exports.AuthzDisabled = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _AuthzDisabled;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let AuthzOptOutReason = exports.AuthzOptOutReason = /*#__PURE__*/function (AuthzOptOutReason) {
  AuthzOptOutReason["DelegateToESClient"] = "Route delegates authorization to the scoped ES client";
  AuthzOptOutReason["DelegateToSOClient"] = "Route delegates authorization to the scoped SO client";
  AuthzOptOutReason["ServeStaticFiles"] = "Route serves static files that do not require authorization";
  return AuthzOptOutReason;
}({});
class AuthzDisabled {
  static fromReason(reason) {
    return {
      enabled: false,
      reason
    };
  }
}
exports.AuthzDisabled = AuthzDisabled;
_AuthzDisabled = AuthzDisabled;
(0, _defineProperty2.default)(AuthzDisabled, "delegateToESClient", _AuthzDisabled.fromReason(AuthzOptOutReason.DelegateToESClient));
(0, _defineProperty2.default)(AuthzDisabled, "delegateToSOClient", _AuthzDisabled.fromReason(AuthzOptOutReason.DelegateToSOClient));
(0, _defineProperty2.default)(AuthzDisabled, "serveStaticFiles", _AuthzDisabled.fromReason(AuthzOptOutReason.ServeStaticFiles));
const unwindNestedSecurityPrivileges = privileges => privileges.reduce((acc, privilege) => {
  if (typeof privilege === 'object') {
    var _privilege$allOf, _privilege$anyOf;
    if ((_privilege$allOf = privilege.allOf) !== null && _privilege$allOf !== void 0 && _privilege$allOf.length) {
      acc.push(...privilege.allOf);
    }
    if (privilege !== null && privilege !== void 0 && (_privilege$anyOf = privilege.anyOf) !== null && _privilege$anyOf !== void 0 && _privilege$anyOf.length) {
      acc.push(...privilege.anyOf);
    }
  } else if (typeof privilege === 'string') {
    acc.push(privilege);
  }
  return acc;
}, []);
exports.unwindNestedSecurityPrivileges = unwindNestedSecurityPrivileges;