"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavControlsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
class NavControlsService {
  constructor() {
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.ReplaySubject(1));
  }
  start() {
    const navControlsLeft$ = new _rxjs.BehaviorSubject(new Set());
    const navControlsRight$ = new _rxjs.BehaviorSubject(new Set());
    const navControlsCenter$ = new _rxjs.BehaviorSubject(new Set());
    const navControlsExtension$ = new _rxjs.BehaviorSubject(new Set());
    const helpMenuLinks$ = new _rxjs.BehaviorSubject([]);
    return {
      // In the future, registration should be moved to the setup phase. This
      // is not possible until the legacy nav controls are no longer supported.
      registerLeft: navControl => navControlsLeft$.next(new Set([...navControlsLeft$.value.values(), navControl])),
      registerRight: navControl => navControlsRight$.next(new Set([...navControlsRight$.value.values(), navControl])),
      registerCenter: navControl => navControlsCenter$.next(new Set([...navControlsCenter$.value.values(), navControl])),
      registerExtension: navControl => navControlsExtension$.next(new Set([...navControlsExtension$.value.values(), navControl])),
      setHelpMenuLinks: links => {
        // This extension point is only intended to be used once by the cloud integration > cloud_links plugin
        if (helpMenuLinks$.value.length > 0) {
          throw new Error(`Help menu links have already been set`);
        }
        helpMenuLinks$.next(links);
      },
      getLeft$: () => navControlsLeft$.pipe((0, _rxjs.map)(controls => (0, _lodash.sortBy)([...controls.values()], 'order')), (0, _rxjs.takeUntil)(this.stop$)),
      getRight$: () => navControlsRight$.pipe((0, _rxjs.map)(controls => (0, _lodash.sortBy)([...controls.values()], 'order')), (0, _rxjs.takeUntil)(this.stop$)),
      getCenter$: () => navControlsCenter$.pipe((0, _rxjs.map)(controls => (0, _lodash.sortBy)([...controls.values()], 'order')), (0, _rxjs.takeUntil)(this.stop$)),
      getExtension$: () => navControlsExtension$.pipe((0, _rxjs.map)(controls => (0, _lodash.sortBy)([...controls.values()], 'order')), (0, _rxjs.takeUntil)(this.stop$)),
      getHelpMenuLinks$: () => helpMenuLinks$.pipe((0, _rxjs.takeUntil)(this.stop$))
    };
  }
  stop() {
    this.stop$.next();
  }
}
exports.NavControlsService = NavControlsService;