"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initTimeRangeSubscription = initTimeRangeSubscription;
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _moment = _interopRequireDefault(require("moment"));
var _rxjs = require("rxjs");
var _publishes_reload = require("@kbn/presentation-publishing/interfaces/fetch/publishes_reload");
var _get_time_range_meta = require("./get_time_range_meta");
var _time_utils = require("./time_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initTimeRangeSubscription(controlGroupApi) {
  const timeRange$ = (0, _presentationPublishing.apiHasParentApi)(controlGroupApi) && (0, _presentationPublishing.apiPublishesTimeRange)(controlGroupApi.parentApi) ? controlGroupApi.parentApi.timeRange$ : new _rxjs.BehaviorSubject(undefined);
  const timeRangeMeta$ = new _rxjs.BehaviorSubject((0, _get_time_range_meta.getTimeRangeMeta)(timeRange$.value));
  const timeRangeSubscription = timeRange$.pipe((0, _rxjs.skip)(1)).subscribe(timeRange => {
    timeRangeMeta$.next((0, _get_time_range_meta.getTimeRangeMeta)(timeRange));
  });
  let reloadSubscription;
  if ((0, _presentationPublishing.apiHasParentApi)(controlGroupApi) && (0, _publishes_reload.apiPublishesReload)(controlGroupApi.parentApi)) {
    reloadSubscription = controlGroupApi.parentApi.reload$.subscribe(() => {
      timeRangeMeta$.next((0, _get_time_range_meta.getTimeRangeMeta)(timeRange$.value));
    });
  }
  return {
    timeRangeMeta$,
    formatDate: epoch => {
      return _moment.default.tz(epoch, (0, _time_utils.getMomentTimezone)((0, _get_time_range_meta.getTimezone)())).locale(_i18n.i18n.getLocale()).format(timeRangeMeta$.value.format);
    },
    cleanupTimeRangeSubscription: () => {
      var _reloadSubscription;
      (_reloadSubscription = reloadSubscription) === null || _reloadSubscription === void 0 ? void 0 : _reloadSubscription.unsubscribe();
      timeRangeSubscription.unsubscribe();
    }
  };
}