"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.controlGroupFetch$ = controlGroupFetch$;
var _publishes_reload = require("@kbn/presentation-publishing/interfaces/fetch/publishes_reload");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function controlGroupFetch$(ignoreParentSettings$, parentApi, onReload) {
  return ignoreParentSettings$.pipe((0, _rxjs.switchMap)(parentIgnoreSettings => {
    const observables = [];
    // Subscribe to parentApi.unifiedSearchFilters$ instead of parentApi.filters$
    // to avoid passing control group filters back into control group
    if (!(parentIgnoreSettings !== null && parentIgnoreSettings !== void 0 && parentIgnoreSettings.ignoreFilters) && parentApi.unifiedSearchFilters$) {
      observables.push(parentApi.unifiedSearchFilters$);
    }
    if (!(parentIgnoreSettings !== null && parentIgnoreSettings !== void 0 && parentIgnoreSettings.ignoreQuery) && parentApi.query$) {
      observables.push(parentApi.query$);
    }
    if (!(parentIgnoreSettings !== null && parentIgnoreSettings !== void 0 && parentIgnoreSettings.ignoreTimerange) && parentApi.timeRange$) {
      observables.push(parentApi.timeRange$);
    }
    if ((0, _publishes_reload.apiPublishesReload)(parentApi)) {
      observables.push(onReload ? parentApi.reload$.pipe((0, _rxjs.tap)(onReload)) : parentApi.reload$);
    }
    return observables.length ? (0, _rxjs.merge)(...observables) : new _rxjs.BehaviorSubject(undefined);
  }), (0, _rxjs.debounceTime)(0), (0, _rxjs.map)(() => {
    const parentIgnoreSettings = ignoreParentSettings$.value;
    return {
      unifiedSearchFilters: parentIgnoreSettings !== null && parentIgnoreSettings !== void 0 && parentIgnoreSettings.ignoreFilters || !parentApi.unifiedSearchFilters$ ? undefined : parentApi.unifiedSearchFilters$.value,
      query: parentIgnoreSettings !== null && parentIgnoreSettings !== void 0 && parentIgnoreSettings.ignoreQuery || !parentApi.query$ ? undefined : parentApi.query$.value,
      timeRange: parentIgnoreSettings !== null && parentIgnoreSettings !== void 0 && parentIgnoreSettings.ignoreTimerange || !parentApi.timeRange$ ? undefined : parentApi.timeRange$.value
    };
  }));
}