"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumbs = (breadcrumbs, params, chromeService) => {
  const {
    docTitle
  } = chromeService;
  const isMultiple = breadcrumbs.length > 1;
  const docTitleValue = isMultiple ? breadcrumbs[breadcrumbs.length - 1].text : breadcrumbs[0].text;
  docTitle.change(docTitleValue);
  (0, _react.useEffect)(() => {
    params.setBreadcrumbs(breadcrumbs);
  }, [breadcrumbs, params]);
};
exports.useBreadcrumbs = useBreadcrumbs;