"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndexExists = exports.IndexExistsApiLogic = void 0;
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchIndexExists = async ({
  indexName,
  http
}) => {
  const route = `/internal/content_connectors/indices/${indexName}/exists`;
  if (http) {
    const {
      exists
    } = await http.get(route);
    return {
      exists,
      indexName
    };
  }
};
exports.fetchIndexExists = fetchIndexExists;
const IndexExistsApiLogic = exports.IndexExistsApiLogic = (0, _create_api_logic.createApiLogic)(['index_exists_api_logic'], fetchIndexExists);