"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.valueToUpdateIsStatus = exports.valueToUpdateIsSettings = exports.getTypedPayload = exports.getIncrementalIdSearchOverrides = exports.decodeSingleCaseMetricsResponse = exports.decodeFindAllAttachedAlertsResponse = exports.decodeCasesResponse = exports.decodeCaseUserActionsResponse = exports.decodeCaseUserActionStatsResponse = exports.decodeCaseResponse = exports.decodeCaseResolveResponse = exports.decodeCaseConfigureResponse = exports.decodeCaseConfigurationsResponse = exports.createUpdateSuccessToaster = exports.createToasterPlainError = exports.covertToSnakeCase = exports.constructReportersFilter = exports.constructCustomFieldsFilter = exports.constructAssigneesFilter = exports.ToasterError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _Either = require("fp-ts/Either");
var _function = require("fp-ts/function");
var _pipeable = require("fp-ts/pipeable");
var _builder = require("../components/custom_fields/builder");
var _domain = require("../../common/types/domain");
var _api = require("../../common/types/api");
var _constants = require("../../common/constants");
var _api2 = require("../../common/api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTypedPayload = a => a;
exports.getTypedPayload = getTypedPayload;
const covertToSnakeCase = obj => (0, _lodash.transform)(obj, (acc, value, key, target) => {
  const camelKey = Array.isArray(target) ? key : (0, _lodash.snakeCase)(key);
  acc[camelKey] = (0, _lodash.isObject)(value) ? covertToSnakeCase(value) : value;
});
exports.covertToSnakeCase = covertToSnakeCase;
const createToasterPlainError = message => new ToasterError([message]);
exports.createToasterPlainError = createToasterPlainError;
const decodeCaseResponse = respCase => (0, _pipeable.pipe)(_domain.CaseRt.decode(respCase), (0, _Either.fold)((0, _api2.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCaseResponse = decodeCaseResponse;
const decodeCaseResolveResponse = respCase => (0, _pipeable.pipe)(_api.CaseResolveResponseRt.decode(respCase), (0, _Either.fold)((0, _api2.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCaseResolveResponse = decodeCaseResolveResponse;
const decodeSingleCaseMetricsResponse = respCase => (0, _pipeable.pipe)(_api.SingleCaseMetricsResponseRt.decode(respCase), (0, _Either.fold)((0, _api2.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeSingleCaseMetricsResponse = decodeSingleCaseMetricsResponse;
const decodeCasesResponse = respCase => (0, _pipeable.pipe)(_domain.CasesRt.decode(respCase), (0, _Either.fold)((0, _api2.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCasesResponse = decodeCasesResponse;
const decodeCaseConfigurationsResponse = respCase => {
  return (0, _pipeable.pipe)(_domain.ConfigurationsRt.decode(respCase), (0, _Either.fold)((0, _api2.throwErrors)(createToasterPlainError), _function.identity));
};
exports.decodeCaseConfigurationsResponse = decodeCaseConfigurationsResponse;
const decodeCaseConfigureResponse = respCase => (0, _pipeable.pipe)(_domain.ConfigurationRt.decode(respCase), (0, _Either.fold)((0, _api2.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCaseConfigureResponse = decodeCaseConfigureResponse;
const decodeCaseUserActionsResponse = respUserActions => (0, _pipeable.pipe)(_domain.UserActionsRt.decode(respUserActions), (0, _Either.fold)((0, _api2.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCaseUserActionsResponse = decodeCaseUserActionsResponse;
const decodeCaseUserActionStatsResponse = caseUserActionsStats => (0, _pipeable.pipe)(_api.CaseUserActionStatsResponseRt.decode(caseUserActionsStats), (0, _Either.fold)((0, _api2.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeCaseUserActionStatsResponse = decodeCaseUserActionStatsResponse;
const decodeFindAllAttachedAlertsResponse = respCase => (0, _function.pipe)(_api.FindCasesContainingAllAlertsResponseRt.decode(respCase), (0, _Either.fold)((0, _api2.throwErrors)(createToasterPlainError), _function.identity));
exports.decodeFindAllAttachedAlertsResponse = decodeFindAllAttachedAlertsResponse;
const valueToUpdateIsSettings = (key, value) => key === 'settings';
exports.valueToUpdateIsSettings = valueToUpdateIsSettings;
const valueToUpdateIsStatus = (key, value) => key === 'status';
exports.valueToUpdateIsStatus = valueToUpdateIsStatus;
class ToasterError extends Error {
  constructor(messages) {
    super(messages[0]);
    (0, _defineProperty2.default)(this, "messages", void 0);
    this.name = 'ToasterError';
    this.messages = messages;
  }
}
exports.ToasterError = ToasterError;
const createUpdateSuccessToaster = (caseBeforeUpdate, caseAfterUpdate, key, value) => {
  const caseHasAlerts = caseBeforeUpdate.comments.some(comment => comment.type === _domain.AttachmentType.alert);
  const toast = {
    title: i18n.UPDATED_CASE(caseAfterUpdate.title),
    className: 'eui-textBreakWord'
  };
  if (valueToUpdateIsSettings(key, value) && value !== null && value !== void 0 && value.syncAlerts && caseHasAlerts && caseBeforeUpdate.settings.syncAlerts !== (value === null || value === void 0 ? void 0 : value.syncAlerts)) {
    return {
      ...toast,
      title: i18n.SYNC_CASE(caseAfterUpdate.title)
    };
  }
  if (valueToUpdateIsSettings(key, value) && caseBeforeUpdate.settings.extractObservables !== (value === null || value === void 0 ? void 0 : value.extractObservables)) {
    return {
      ...toast,
      title: i18n.EXTRACT_OBSERVABLES(caseAfterUpdate.title)
    };
  }
  if (valueToUpdateIsStatus(key, value) && caseHasAlerts && caseBeforeUpdate.settings.syncAlerts) {
    return {
      ...toast,
      text: i18n.STATUS_CHANGED_TOASTER_TEXT
    };
  }
  return toast;
};
exports.createUpdateSuccessToaster = createUpdateSuccessToaster;
const constructAssigneesFilter = assignees => {
  var _assignees$map;
  return assignees.length > 0 ? {
    assignees: (_assignees$map = assignees === null || assignees === void 0 ? void 0 : assignees.map(assignee => assignee === null ? _constants.NO_ASSIGNEES_FILTERING_KEYWORD : assignee)) !== null && _assignees$map !== void 0 ? _assignees$map : [_constants.NO_ASSIGNEES_FILTERING_KEYWORD]
  } : {};
};
exports.constructAssigneesFilter = constructAssigneesFilter;
const constructReportersFilter = reporters => {
  return reporters.length > 0 ? {
    reporters: reporters.map(reporter => {
      var _reporter$username;
      if (reporter.profile_uid != null) {
        return reporter.profile_uid;
      }
      return (_reporter$username = reporter.username) !== null && _reporter$username !== void 0 ? _reporter$username : '';
    }).filter(reporterID => !(0, _lodash.isEmpty)(reporterID))
  } : {};
};
exports.constructReportersFilter = constructReportersFilter;
const constructCustomFieldsFilter = optionKeysByCustomFieldKey => {
  if (!optionKeysByCustomFieldKey || Object.keys(optionKeysByCustomFieldKey).length === 0) {
    return {};
  }
  const valuesByCustomFieldKey = {};
  for (const [customFieldKey, customField] of Object.entries(optionKeysByCustomFieldKey)) {
    const {
      type,
      options: selectedOptions
    } = customField;
    if (_builder.builderMap[type]) {
      const {
        filterOptions: customFieldFilterOptionsConfig = []
      } = _builder.builderMap[type]();
      const values = selectedOptions.map(selectedOption => {
        const filterOptionConfig = customFieldFilterOptionsConfig.find(filterOption => filterOption.key === selectedOption);
        return filterOptionConfig ? filterOptionConfig.value : undefined;
      }).filter(option => option !== undefined);
      if (values.length > 0) {
        valuesByCustomFieldKey[customFieldKey] = values;
      }
    }
  }
  return Object.keys(valuesByCustomFieldKey).length ? {
    customFields: valuesByCustomFieldKey
  } : {};
};
exports.constructCustomFieldsFilter = constructCustomFieldsFilter;
const getIncrementalIdSearchOverrides = search => {
  var _trimmedSearch;
  const incrementalIdRegEx = /^#(\d{1,50})\s*$/;
  // overrides for incremental_id search
  let overrides = {};
  let trimmedSearch = search === null || search === void 0 ? void 0 : search.trim();
  const isIncrementalIdSearch = incrementalIdRegEx.test((_trimmedSearch = trimmedSearch) !== null && _trimmedSearch !== void 0 ? _trimmedSearch : '');
  if (trimmedSearch && isIncrementalIdSearch) {
    var _incrementalIdRegEx$e, _incrementalIdRegEx$e2;
    // extract the number portion of the inc id search: #123 -> 123
    trimmedSearch = (_incrementalIdRegEx$e = (_incrementalIdRegEx$e2 = incrementalIdRegEx.exec(trimmedSearch)) === null || _incrementalIdRegEx$e2 === void 0 ? void 0 : _incrementalIdRegEx$e2[1]) !== null && _incrementalIdRegEx$e !== void 0 ? _incrementalIdRegEx$e : trimmedSearch;
    // search only in `incremental_id` since types with `title`
    // and `description` don't overlap
    overrides = {
      searchFields: ['incremental_id.text'],
      search: trimmedSearch
    };
  }
  return overrides;
};
exports.getIncrementalIdSearchOverrides = getIncrementalIdSearchOverrides;