"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_ALL_CASES = exports.START_A_NEW_CASE = exports.RECENT_CASES = exports.RECENTLY_CREATED_CASES = exports.NO_CASES_READ_ONLY = exports.NO_CASES_ASSIGNED_TO_ME = exports.NO_CASES = exports.MY_RECENTLY_REPORTED_CASES = exports.MY_RECENTLY_ASSIGNED_CASES = exports.COMMENTS = exports.CASES_FILTER_CONTROL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMMENTS = exports.COMMENTS = _i18n.i18n.translate('xpack.cases.recentCases.commentsTooltip', {
  defaultMessage: 'Comments'
});
const MY_RECENTLY_REPORTED_CASES = exports.MY_RECENTLY_REPORTED_CASES = _i18n.i18n.translate('xpack.cases.recentCases.myRecentlyReportedCasesLabel', {
  defaultMessage: 'Created by me'
});
const MY_RECENTLY_ASSIGNED_CASES = exports.MY_RECENTLY_ASSIGNED_CASES = _i18n.i18n.translate('xpack.cases.recentCases.myRecentlyAssignedCasesLabel', {
  defaultMessage: 'Assigned to me'
});
const NO_CASES = exports.NO_CASES = _i18n.i18n.translate('xpack.cases.recentCases.noCasesMessage', {
  defaultMessage: 'No cases have been created yet. Put your detective hat on and'
});
const NO_CASES_READ_ONLY = exports.NO_CASES_READ_ONLY = _i18n.i18n.translate('xpack.cases.recentCases.noCasesMessageReadOnly', {
  defaultMessage: 'No cases have been created yet.'
});
const NO_CASES_ASSIGNED_TO_ME = exports.NO_CASES_ASSIGNED_TO_ME = _i18n.i18n.translate('xpack.cases.recentCases.noCasesMessageAssignedToMe', {
  defaultMessage: 'No cases have been recently assigned to you.'
});
const RECENT_CASES = exports.RECENT_CASES = _i18n.i18n.translate('xpack.cases.recentCases.recentCasesSidebarTitle', {
  defaultMessage: 'Recent cases'
});
const RECENTLY_CREATED_CASES = exports.RECENTLY_CREATED_CASES = _i18n.i18n.translate('xpack.cases.recentCases.recentlyCreatedCasesLabel', {
  defaultMessage: 'Created by anyone'
});
const START_A_NEW_CASE = exports.START_A_NEW_CASE = _i18n.i18n.translate('xpack.cases.recentCases.startNewCaseLink', {
  defaultMessage: 'start a new case'
});
const VIEW_ALL_CASES = exports.VIEW_ALL_CASES = _i18n.i18n.translate('xpack.cases.recentCases.viewAllCasesLink', {
  defaultMessage: 'View all cases'
});
const CASES_FILTER_CONTROL = exports.CASES_FILTER_CONTROL = _i18n.i18n.translate('xpack.cases.recentCases.controlLegend', {
  defaultMessage: 'Cases filter'
});