"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  /**
   * For internal use. A list of string values (comma delimited) that will enable experimental
   * type of functionality that is not yet released. Valid values for this settings need to
   * be defined in:
   * `x-pack/platform/plugins/shared/automatic_import/common/experimental_features.ts`
   * under the `allowedExperimentalValues` object
   *
   * @example
   * xpack.automatic_import.enableExperimental:
   *   - someCrazyFeature
   *   - someEvenCrazierFeature
   */
  enableExperimental: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: () => []
  })
});
const config = exports.config = {
  exposeToBrowser: {
    enableExperimental: true
  },
  schema: configSchema,
  deprecations: ({
    renameFromRoot
  }) => [renameFromRoot('xpack.integration_assistant.enabled', 'xpack.automatic_import.enabled', {
    level: 'critical'
  }), renameFromRoot('xpack.integration_assistant.enableExperimental', 'xpack.automatic_import.enableExperimental', {
    level: 'critical'
  })]
};