"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmIndexSettings = getApmIndexSettings;
exports.getApmIndices = getApmIndices;
var _apm_indices = require("../saved_objects/apm_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmIndices({
  sources,
  context
}) {
  const coreContext = await context.core;
  return await sources.getApmIndices(coreContext.savedObjects.client);
}
async function getApmIndexSettings({
  sources,
  context
}) {
  const {
    apmIndicesFromConfigFile
  } = sources;
  const coreContext = await context.core;
  const apmIndicesSavedObject = await (0, _apm_indices.getApmIndicesSavedObject)(coreContext.savedObjects.client);
  const apmIndicesConfigFile = Object.entries(apmIndicesFromConfigFile);
  return {
    apmIndexSettings: apmIndicesConfigFile.map(([configurationName, defaultValue]) => ({
      configurationName,
      defaultValue,
      // value defined in kibana[.dev].yml
      savedValue: apmIndicesSavedObject === null || apmIndicesSavedObject === void 0 ? void 0 : apmIndicesSavedObject[configurationName] // value saved via Saved Objects service
    }))
  };
}