"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTransactionDurationRuleType = registerTransactionDurationRuleType;
exports.transactionDurationActionVariables = void 0;
var _server = require("@kbn/core/server");
var _server2 = require("@kbn/alerting-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _server3 = require("@kbn/observability-plugin/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common2 = require("@kbn/spaces-plugin/common");
var _transaction_duration = require("@kbn/response-ops-rule-params/transaction_duration");
var _objectUtils = require("@kbn/object-utils");
var _get_groupby_terms = require("../utils/get_groupby_terms");
var _aggregated_transactions = require("../../../../../common/aggregated_transactions");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _apm = require("../../../../../common/es_fields/apm");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _environment_query = require("../../../../../common/utils/environment_query");
var _formatters = require("../../../../../common/utils/formatters");
var _transactions = require("../../../../lib/helpers/transactions");
var _action_variables = require("../../action_variables");
var _alerting_es_client = require("../../alerting_es_client");
var _register_apm_rule_types = require("../../register_apm_rule_types");
var _get_apm_alert_source_fields = require("../get_apm_alert_source_fields");
var _average_or_percentile_agg = require("./average_or_percentile_agg");
var _get_groupby_action_variables = require("../utils/get_groupby_action_variables");
var _get_all_groupby_fields = require("../../../../../common/rules/get_all_groupby_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTypeConfig = _apm_rule_types.RULE_TYPES_CONFIG[_ruleDataUtils.ApmRuleType.TransactionDuration];
const transactionDurationActionVariables = exports.transactionDurationActionVariables = [_action_variables.apmActionVariables.alertDetailsUrl, _action_variables.apmActionVariables.environment, _action_variables.apmActionVariables.interval, _action_variables.apmActionVariables.reason, _action_variables.apmActionVariables.serviceName, _action_variables.apmActionVariables.threshold, _action_variables.apmActionVariables.transactionName, _action_variables.apmActionVariables.transactionType, _action_variables.apmActionVariables.triggerValue, _action_variables.apmActionVariables.viewInAppUrl, _action_variables.apmActionVariables.grouping];
function registerTransactionDurationRuleType({
  alerting,
  apmConfig,
  getApmIndices,
  basePath
}) {
  if (!alerting) {
    throw new Error('Cannot register transaction duration rule type. Both the actions and alerting plugins need to be enabled.');
  }
  alerting.registerType({
    id: _ruleDataUtils.ApmRuleType.TransactionDuration,
    name: ruleTypeConfig.name,
    actionGroups: ruleTypeConfig.actionGroups,
    defaultActionGroupId: ruleTypeConfig.defaultActionGroupId,
    validate: {
      params: _transaction_duration.transactionDurationParamsSchema
    },
    doesSetRecoveryContext: true,
    schemas: {
      params: {
        type: 'config-schema',
        schema: _transaction_duration.transactionDurationParamsSchema
      }
    },
    actionVariables: {
      context: transactionDurationActionVariables
    },
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: _apm_rule_types.APM_SERVER_FEATURE_ID,
    solution: _common.observabilityFeatureId,
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: async options => {
      var _ruleParams$searchCon, _ruleParams$searchCon2, _ruleParams$searchCon3, _ruleParams$searchCon4, _alertsClient$getReco;
      const {
        params: ruleParams,
        services,
        spaceId,
        getTimeRange
      } = options;
      const {
        alertsClient,
        savedObjectsClient,
        scopedClusterClient,
        uiSettingsClient
      } = services;
      if (!alertsClient) {
        throw new _server2.AlertsClientError();
      }
      const allGroupByFields = (0, _get_all_groupby_fields.getAllGroupByFields)(_ruleDataUtils.ApmRuleType.TransactionDuration, ruleParams.groupBy);
      const indices = await getApmIndices(savedObjectsClient);

      // only query transaction events when set to 'never',
      // to prevent (likely) unnecessary blocking request
      // in rule execution
      const searchAggregatedTransactions = apmConfig.searchAggregatedTransactions !== _aggregated_transactions.SearchAggregatedTransactionSetting.never;
      const index = searchAggregatedTransactions ? indices.metric : indices.transaction;
      const field = (0, _transactions.getDurationFieldForTransactions)(searchAggregatedTransactions);
      const termFilterQuery = !((_ruleParams$searchCon = ruleParams.searchConfiguration) !== null && _ruleParams$searchCon !== void 0 && (_ruleParams$searchCon2 = _ruleParams$searchCon.query) !== null && _ruleParams$searchCon2 !== void 0 && _ruleParams$searchCon2.query) ? [...(0, _server3.termQuery)(_apm.SERVICE_NAME, ruleParams.serviceName, {
        queryEmptyString: false
      }), ...(0, _server3.termQuery)(_apm.TRANSACTION_TYPE, ruleParams.transactionType, {
        queryEmptyString: false
      }), ...(0, _server3.termQuery)(_apm.TRANSACTION_NAME, ruleParams.transactionName, {
        queryEmptyString: false
      }), ...(0, _environment_query.environmentQuery)(ruleParams.environment)] : [];
      const {
        dateStart
      } = getTimeRange(`${ruleParams.windowSize}${ruleParams.windowUnit}`);
      const searchParams = {
        index,
        track_total_hits: false,
        size: 0,
        _source: false,
        query: {
          bool: {
            filter: [{
              range: {
                '@timestamp': {
                  gte: dateStart
                }
              }
            }, ...(0, _transactions.getBackwardCompatibleDocumentTypeFilter)(searchAggregatedTransactions), ...termFilterQuery, ...(0, _server3.getParsedFilterQuery)((_ruleParams$searchCon3 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon3 === void 0 ? void 0 : (_ruleParams$searchCon4 = _ruleParams$searchCon3.query) === null || _ruleParams$searchCon4 === void 0 ? void 0 : _ruleParams$searchCon4.query)]
          }
        },
        aggs: {
          series: {
            multi_terms: {
              terms: [...(0, _get_groupby_terms.getGroupByTerms)(allGroupByFields)],
              size: 1000,
              ...(0, _average_or_percentile_agg.getMultiTermsSortOrder)(ruleParams.aggregationType)
            },
            aggs: {
              ...(0, _average_or_percentile_agg.averageOrPercentileAgg)({
                aggregationType: ruleParams.aggregationType,
                transactionDurationField: field
              }),
              ...(0, _get_apm_alert_source_fields.getApmAlertSourceFieldsAgg)()
            }
          }
        }
      };
      const response = await (0, _alerting_es_client.alertingEsClient)({
        scopedClusterClient,
        uiSettingsClient,
        params: searchParams
      });
      if (!response.aggregations) {
        return {
          state: {}
        };
      }

      // Converts threshold to microseconds because this is the unit used on transactionDuration
      const thresholdMicroseconds = ruleParams.threshold * 1000;
      const triggeredBuckets = [];
      for (const bucket of response.aggregations.series.buckets) {
        const groupByFields = bucket.key.reduce((obj, bucketKey, bucketIndex) => {
          obj[allGroupByFields[bucketIndex]] = bucketKey;
          return obj;
        }, {});
        const bucketKey = bucket.key;
        const transactionDuration = 'avgLatency' in bucket // only true if ruleParams.aggregationType === 'avg'
        ? bucket.avgLatency.value : bucket.pctLatency.values[0].value;
        if (transactionDuration !== null && transactionDuration > thresholdMicroseconds) {
          triggeredBuckets.push({
            sourceFields: (0, _get_apm_alert_source_fields.getApmAlertSourceFields)(bucket),
            transactionDuration,
            groupByFields,
            bucketKey
          });
        }
      }
      for (const {
        transactionDuration,
        sourceFields,
        groupByFields,
        bucketKey
      } of triggeredBuckets) {
        var _getEnvironmentEsFiel;
        const durationFormatter = (0, _formatters.getDurationFormatter)(transactionDuration);
        const transactionDurationFormatted = durationFormatter(transactionDuration).formatted;
        const reason = (0, _apm_rule_types.formatTransactionDurationReason)({
          aggregationType: String(ruleParams.aggregationType),
          asDuration: _common.asDuration,
          measured: transactionDuration,
          threshold: thresholdMicroseconds,
          windowSize: ruleParams.windowSize,
          windowUnit: ruleParams.windowUnit,
          groupByFields
        });
        const alertId = bucketKey.join('_');
        const {
          uuid
        } = alertsClient.report({
          id: alertId,
          actionGroup: ruleTypeConfig.defaultActionGroupId
        });
        const alertDetailsUrl = (0, _common.getAlertDetailsUrl)(basePath, spaceId, uuid);
        const viewInAppUrl = (0, _common2.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, (0, _formatters.getAlertUrlTransaction)(groupByFields[_apm.SERVICE_NAME], (_getEnvironmentEsFiel = (0, _environment_filter_values.getEnvironmentEsField)(groupByFields[_apm.SERVICE_ENVIRONMENT])) === null || _getEnvironmentEsFiel === void 0 ? void 0 : _getEnvironmentEsFiel[_apm.SERVICE_ENVIRONMENT], groupByFields[_apm.TRANSACTION_TYPE]));
        const groupByActionVariables = (0, _get_groupby_action_variables.getGroupByActionVariables)(groupByFields);
        const groupingObject = (0, _objectUtils.unflattenObject)(groupByFields);
        const context = {
          alertDetailsUrl,
          interval: (0, _common.formatDurationFromTimeUnitChar)(ruleParams.windowSize, ruleParams.windowUnit),
          reason,
          // When group by doesn't include transaction.name, the context.transaction.name action variable will contain value of the Transaction Name filter
          transactionName: ruleParams.transactionName,
          threshold: ruleParams.threshold,
          triggerValue: transactionDurationFormatted,
          viewInAppUrl,
          grouping: groupingObject,
          ...groupByActionVariables
        };
        const payload = {
          [_apm.TRANSACTION_NAME]: ruleParams.transactionName,
          [_apm.PROCESSOR_EVENT]: _common.ProcessorEvent.transaction,
          [_ruleDataUtils.ALERT_EVALUATION_VALUE]: transactionDuration,
          [_ruleDataUtils.ALERT_EVALUATION_THRESHOLD]: thresholdMicroseconds,
          [_ruleDataUtils.ALERT_REASON]: reason,
          ...sourceFields,
          ...groupByFields
        };
        alertsClient.setAlertData({
          id: alertId,
          payload,
          context
        });
      }
      // Handle recovered alerts context
      const recoveredAlerts = (_alertsClient$getReco = alertsClient.getRecoveredAlerts()) !== null && _alertsClient$getReco !== void 0 ? _alertsClient$getReco : [];
      for (const recoveredAlert of recoveredAlerts) {
        var _ruleParamsOfRecovere, _getEnvironmentEsFiel2;
        const alertHits = recoveredAlert.hit;
        const recoveredAlertId = recoveredAlert.alert.getId();
        const alertUuid = recoveredAlert.alert.getUuid();
        const alertDetailsUrl = (0, _common.getAlertDetailsUrl)(basePath, spaceId, alertUuid);
        const ruleParamsOfRecoveredAlert = alertHits === null || alertHits === void 0 ? void 0 : alertHits[_ruleDataUtils.ALERT_RULE_PARAMETERS];
        const groupByFieldsOfRecoveredAlert = (_ruleParamsOfRecovere = ruleParamsOfRecoveredAlert === null || ruleParamsOfRecoveredAlert === void 0 ? void 0 : ruleParamsOfRecoveredAlert.groupBy) !== null && _ruleParamsOfRecovere !== void 0 ? _ruleParamsOfRecovere : [];
        const allGroupByFieldsOfRecoveredAlert = (0, _get_all_groupby_fields.getAllGroupByFields)(_ruleDataUtils.ApmRuleType.TransactionDuration, groupByFieldsOfRecoveredAlert);
        const groupByFields = allGroupByFieldsOfRecoveredAlert.reduce((acc, sourceField) => {
          if ((alertHits === null || alertHits === void 0 ? void 0 : alertHits[sourceField]) !== undefined) {
            acc[sourceField] = alertHits[sourceField];
          }
          return acc;
        }, {});
        const viewInAppUrl = (0, _common2.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, (0, _formatters.getAlertUrlTransaction)(groupByFields[_apm.SERVICE_NAME], (_getEnvironmentEsFiel2 = (0, _environment_filter_values.getEnvironmentEsField)(groupByFields[_apm.SERVICE_ENVIRONMENT])) === null || _getEnvironmentEsFiel2 === void 0 ? void 0 : _getEnvironmentEsFiel2[_apm.SERVICE_ENVIRONMENT], groupByFields[_apm.TRANSACTION_TYPE]));
        const durationFormatter = (0, _formatters.getDurationFormatter)(alertHits === null || alertHits === void 0 ? void 0 : alertHits[_ruleDataUtils.ALERT_EVALUATION_VALUE]);
        const transactionDurationFormatted = durationFormatter(alertHits === null || alertHits === void 0 ? void 0 : alertHits[_ruleDataUtils.ALERT_EVALUATION_VALUE]).formatted;
        const groupByActionVariables = (0, _get_groupby_action_variables.getGroupByActionVariables)(groupByFields);
        const groupingObject = (0, _objectUtils.unflattenObject)(groupByFields);
        const recoveredContext = {
          alertDetailsUrl,
          interval: (0, _common.formatDurationFromTimeUnitChar)(ruleParams.windowSize, ruleParams.windowUnit),
          reason: alertHits === null || alertHits === void 0 ? void 0 : alertHits[_ruleDataUtils.ALERT_REASON],
          // When group by doesn't include transaction.name, the context.transaction.name action variable will contain value of the Transaction Name filter
          transactionName: ruleParams.transactionName,
          threshold: ruleParams.threshold,
          triggerValue: transactionDurationFormatted,
          viewInAppUrl,
          grouping: groupingObject,
          ...groupByActionVariables
        };
        alertsClient.setAlertData({
          id: recoveredAlertId,
          context: recoveredContext
        });
      }
      return {
        state: {}
      };
    },
    alerts: _register_apm_rule_types.ApmRuleTypeAlertDefinition,
    getViewInAppRelativeUrl: ({
      rule
    }) => _common.observabilityPaths.ruleDetails(rule.id)
  });
}