"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnyOfApmParams = useAnyOfApmParams;
exports.useApmParams = useApmParams;
exports.useMaybeApmParams = useMaybeApmParams;
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// these three different functions exist purely to speed up completions from
// TypeScript. One overloaded function is expensive because of the size of the
// union type that is created.

function useMaybeApmParams(path) {
  return (0, _typedReactRouterConfig.useParams)(path, true);
}
function useApmParams(path) {
  return (0, _typedReactRouterConfig.useParams)(path);
}
function useAnyOfApmParams(...paths) {
  return (0, _typedReactRouterConfig.useParams)(...paths);
}