"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmEnvironmentFilter = ApmEnvironmentFilter;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _url_helpers = require("../links/url_helpers");
var _environment_select = require("../environment_select");
var _use_environments_context = require("../../../context/environments_context/use_environments_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/environment_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function updateEnvironmentUrl(history, location, environment) {
  const nextEnvironmentQueryParam = environment;
  history.push({
    ...location,
    search: (0, _url_helpers.fromQuery)({
      ...(0, _url_helpers.toQuery)(location.search),
      environment: nextEnvironmentQueryParam
    })
  });
}
function ApmEnvironmentFilter() {
  const {
    environment,
    environments,
    status,
    rangeFrom,
    rangeTo,
    serviceName
  } = (0, _use_environments_context.useEnvironmentsContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  if (!rangeFrom || !rangeTo) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_environment_select.EnvironmentSelect, {
    status: status,
    environment: environment,
    availableEnvironments: environments,
    serviceName: serviceName,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    onChange: changeValue => updateEnvironmentUrl(history, location, changeValue),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  });
}