"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageExplorer = StorageExplorer;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _index_lifecycle_phase_select = require("./index_lifecycle_phase_select");
var _services_table = require("./services_table");
var _search_bar = require("../../shared/search_bar/search_bar");
var _storage_chart = require("./storage_chart");
var _permission_denied = require("./prompts/permission_denied");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _summary_stats = require("./summary_stats");
var _environment_filter = require("../../shared/environment_filter");
var _tips_and_resources = require("./resources/tips_and_resources");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _get_storage_explorer_links = require("./get_storage_explorer_links");
var _use_progressive_fetcher = require("../../../hooks/use_progressive_fetcher");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/storage_explorer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CALLOUT_DISMISS_INITIAL_STATE = {
  crossClusterSearch: false,
  optimizePerformance: false
};
const dismissButtonText = _i18n.i18n.translate('xpack.apm.storageExplorer.callout.dimissButton', {
  defaultMessage: 'Dismiss'
});
function StorageExplorer() {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      indexLifecyclePhase
    }
  } = (0, _use_apm_params.useApmParams)('/storage-explorer');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const [calloutDismissed, setCalloutDismissed] = (0, _use_local_storage.useLocalStorage)('apm.storageExplorer.calloutDismissed', CALLOUT_DISMISS_INITIAL_STATE);
  const {
    data: hasPrivilegesData,
    status: hasPrivilegesStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/storage_explorer/privileges');
  }, []);
  const {
    data: isCrossClusterSearchData
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!calloutDismissed.crossClusterSearch) {
      return callApmApi('GET /internal/apm/storage_explorer/is_cross_cluster_search');
    }
  }, [calloutDismissed]);
  const {
    data: summaryStatsData,
    status: summaryStatsStatus
  } = (0, _use_progressive_fetcher.useProgressiveFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/storage_explorer_summary_stats', {
      params: {
        query: {
          indexLifecyclePhase,
          environment,
          kuery,
          start,
          end
        }
      }
    });
  }, [indexLifecyclePhase, environment, kuery, start, end]);
  const loadingSummaryStats = (0, _use_fetcher.isPending)(summaryStatsStatus);
  const hasSummaryStatsData = !(0, _lodash.isEmpty)(summaryStatsData);
  const loading = hasPrivilegesStatus === _use_fetcher.FETCH_STATUS.LOADING;
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 15
        }
      }),
      titleSize: "xs",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.apm.storageExplorer.loadingPromptTitle', {
        defaultMessage: 'Loading Storage explorer...'
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 7
      }
    });
  }
  if (!(hasPrivilegesData !== null && hasPrivilegesData !== void 0 && hasPrivilegesData.hasPrivileges)) {
    return /*#__PURE__*/_react.default.createElement(_permission_denied.PermissionDenied, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_environment_filter.ApmEnvironmentFilter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_index_lifecycle_phase_select.IndexLifecyclePhaseSelect, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }), !calloutDismissed.optimizePerformance && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.apm.storageExplorer.longLoadingTimeCalloutTitle', {
      defaultMessage: 'Long loading time?'
    }),
    iconType: "timeRefresh",
    "data-test-subj": "apmStorageExplorerLongLoadingTimeCallout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.storageExplorer.longLoadingTimeCalloutText",
    defaultMessage: "Enable progressive loading of data and optimized sorting for services list in {kibanaAdvancedSettingsLink}.",
    values: {
      kibanaAdvancedSettingsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmStorageExplorerKibanaAdvancedSettingsLink",
        href: (0, _get_storage_explorer_links.getKibanaAdvancedSettingsHref)(core),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.apm.storageExplorer.longLoadingTimeCalloutLink', {
        defaultMessage: 'Kibana advanced settings'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmStorageExplorerButton",
    onClick: () => setCalloutDismissed({
      ...calloutDismissed,
      optimizePerformance: true
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, dismissButtonText)), !calloutDismissed.crossClusterSearch && (isCrossClusterSearchData === null || isCrossClusterSearchData === void 0 ? void 0 : isCrossClusterSearchData.isCrossClusterSearch) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.apm.storageExplorer.crossClusterSearchCalloutTitle', {
      defaultMessage: 'Searching across clusters?'
    }),
    iconType: "search",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.storageExplorer.crossClusterSearchCalloutText', {
    defaultMessage: 'While getting document count works with cross-cluster search, index statistics such as size are only displayed for data that are stored in this cluster.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmStorageExplorerButton",
    onClick: () => setCalloutDismissed({
      ...calloutDismissed,
      crossClusterSearch: true
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }, dismissButtonText))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_summary_stats.SummaryStats, {
    data: summaryStatsData,
    loading: loadingSummaryStats,
    hasData: hasSummaryStatsData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_storage_chart.StorageChart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_services_table.ServicesTable, {
    summaryStatsData: summaryStatsData,
    loadingSummaryStats: loadingSummaryStats,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_tips_and_resources.TipsAndResources, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }));
}