"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeneralSettings = GeneralSettings;
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_profiling_integration_setting = require("../../../../hooks/use_profiling_integration_setting");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/general_settings/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LazyFieldRow = /*#__PURE__*/_react.default.lazy(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/management-settings-components-field-row')))).FieldRow
}));
const FieldRow = (0, _sharedUxUtility.withSuspense)(LazyFieldRow);
const SETTINGS_KEYS = [_common.enableComparisonByDefault, _common.defaultApmServiceEnvironment, _common.apmServiceGroupMaxNumberOfServices, _common.enableInspectEsQueries, _common.apmProgressiveLoading, _common.apmAWSLambdaPriceFactor, _common.apmAWSLambdaRequestCostPerMillion, _common.apmEnableTableSearchBar, _common.apmEnableServiceInventoryTableSearchBar];
function getApmSettingsKeys(isProfilingPluginEnabled) {
  if (isProfilingPluginEnabled) {
    SETTINGS_KEYS.push(...[_common.apmEnableTransactionProfiling]);
  }
  return SETTINGS_KEYS;
}
function GeneralSettings() {
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const {
    docLinks,
    notifications,
    settings,
    application
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  const canSave = application.capabilities.advancedSettings.save && application.capabilities.apm['settings:save'];
  const isProfilingPluginEnabled = (0, _use_profiling_integration_setting.useProfilingPluginSetting)();
  const apmSettingsKeys = getApmSettingsKeys(isProfilingPluginEnabled);
  const {
    fields,
    handleFieldChange,
    unsavedChanges,
    saveAll,
    isSaving,
    cleanUnsavedChanges
  } = (0, _public.useEditableSettings)(apmSettingsKeys);
  async function handleSave() {
    try {
      const reloadPage = Object.keys(unsavedChanges).some(key => {
        return fields[key].requiresPageReload;
      });
      await saveAll();
      trackApmEvent({
        metric: 'general_settings_save'
      });
      if (reloadPage) {
        window.location.reload();
      }
    } catch (e) {
      const error = e;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.apmSettings.save.error', {
          defaultMessage: 'An error occurred while saving the settings'
        }),
        text: error.message
      });
    }
  }
  const hasInvalidChanges = Object.values(unsavedChanges).some(({
    isInvalid
  }) => isInvalid);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), apmSettingsKeys.map(settingKey => {
    const field = fields[settingKey];
    return /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
      links: docLinks.links.management,
      showDanger: message => notifications.toasts.addDanger(message),
      validateChange: (key, value) => settings.client.validateValue(key, value),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(FieldRow, {
      field: field,
      isSavingEnabled: canSave,
      onFieldChange: handleFieldChange,
      unsavedChange: unsavedChanges[settingKey],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }));
  }), !(0, _lodash.isEmpty)(unsavedChanges) && /*#__PURE__*/_react.default.createElement(_public.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: cleanUnsavedChanges,
    onSave: handleSave,
    saveLabel: _i18n.i18n.translate('xpack.apm.apmSettings.saveButton', {
      defaultMessage: 'Save changes'
    }),
    unsavedChangesCount: Object.keys(unsavedChanges).length,
    appTestSubj: "apm",
    areChangesInvalid: hasInvalidChanges,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }));
}