"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = ConfirmDeleteModal;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_keys/confirm_delete_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ConfirmDeleteModal({
  agentKey,
  onCancel,
  onConfirm
}) {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  const {
    id,
    name
  } = agentKey;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const deleteAgentKey = async () => {
    try {
      await (0, _create_call_apm_api.callApmApi)('POST /internal/apm/api_key/invalidate', {
        signal: null,
        params: {
          body: {
            id
          }
        }
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.apm.settings.agentKeys.invalidate.succeeded', {
        defaultMessage: 'Deleted APM agent key "{name}"',
        values: {
          name
        }
      }));
    } catch (error) {
      toasts.addDanger(_i18n.i18n.translate('xpack.apm.settings.agentKeys.invalidate.failed', {
        defaultMessage: 'Error deleting APM agent key "{name}"',
        values: {
          name
        }
      }));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: _i18n.i18n.translate('xpack.apm.settings.agentKeys.deleteConfirmModal.title', {
      defaultMessage: 'Delete APM agent key "{name}"?',
      values: {
        name
      }
    }),
    onCancel: onCancel,
    onConfirm: async () => {
      setIsDeleting(true);
      await deleteAgentKey();
      setIsDeleting(false);
      onConfirm();
    },
    cancelButtonText: _i18n.i18n.translate('xpack.apm.settings.agentKeys.deleteConfirmModal.cancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.apm.settings.agentKeys.deleteConfirmModal.delete', {
      defaultMessage: 'Delete'
    }),
    confirmButtonDisabled: isDeleting,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  });
}