"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTaskRunError = getTaskRunError;
var _task_running = require("@kbn/task-manager-plugin/server/task_running");
var _result_type = require("../../lib/result_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTaskRunError({
  runRuleResult,
  logger,
  ruleResult,
  ruleTypeId,
  ruleId
}) {
  if ((0, _result_type.isErr)(runRuleResult)) {
    return {
      taskRunError: (0, _task_running.createTaskRunError)(runRuleResult.error, (0, _task_running.getErrorSource)(runRuleResult.error))
    };
  }
  const {
    errors: errorsFromLastRun
  } = ruleResult.getLastRunResults();
  if (errorsFromLastRun.length > 0) {
    const isLastRunUserError = !errorsFromLastRun.some(lastRunError => !lastRunError.userError);
    const errorSource = isLastRunUserError ? _task_running.TaskErrorSource.USER : _task_running.TaskErrorSource.FRAMEWORK;
    const lasRunErrorMessages = errorsFromLastRun.map(lastRunError => lastRunError.message).join(',');
    const errorMessage = `Executing Rule ${ruleTypeId}:${ruleId} has resulted in the following error(s): ${lasRunErrorMessages}`;
    logger.error(errorMessage, {
      tags: [ruleTypeId, ruleId, 'rule-run-failed', `${errorSource}-error`]
    });
    return {
      taskRunError: (0, _task_running.createTaskRunError)(new Error(errorMessage), errorSource)
    };
  }
  return {};
}