"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaintenanceWindowExpirationDate = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Returns a date in ISO format one year in the future if the rule is recurring or until the end of the MW if it is not recurring.
const getMaintenanceWindowExpirationDate = ({
  rRule,
  duration
}) => {
  let expirationDate;
  if (rRule.interval || rRule.freq) {
    expirationDate = (0, _moment.default)().utc().add(1, 'year').toISOString();
  } else {
    expirationDate = (0, _moment.default)(rRule.dtstart).utc().add(duration, 'ms').toISOString();
  }
  return expirationDate;
};
exports.getMaintenanceWindowExpirationDate = getMaintenanceWindowExpirationDate;