"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddChangePointChartAction = createAddChangePointChartAction;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _presentationUtil = require("@kbn/presentation-util");
var _public = require("@kbn/ui-actions-plugin/public");
var _constants = require("@kbn/aiops-change-point-detection/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/ui_actions/create_change_point_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const parentApiIsCompatible = async parentApi => {
  const {
    apiIsPresentationContainer
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/presentation-containers')));
  // we cannot have an async type check, so return the casted parentApi rather than a boolean
  return apiIsPresentationContainer(parentApi) ? parentApi : undefined;
};
function createAddChangePointChartAction(coreStart, pluginStart) {
  return {
    id: 'create-change-point-chart',
    grouping: [{
      id: 'ml',
      getDisplayName: () => _i18n.i18n.translate('xpack.aiops.navMenu.mlAppNameText', {
        defaultMessage: 'Machine Learning and Analytics'
      }),
      getIconType: () => 'machineLearningApp'
    }],
    order: 10,
    getIconType: () => 'changePointDetection',
    getDisplayName: () => _i18n.i18n.translate('xpack.aiops.embeddableChangePointChartDisplayName', {
      defaultMessage: 'Change point detection'
    }),
    async isCompatible(context) {
      return Boolean(await parentApiIsCompatible(context.embeddable));
    },
    async execute(context) {
      const presentationContainerParent = await parentApiIsCompatible(context.embeddable);
      if (!presentationContainerParent) throw new _public.IncompatibleActionError();
      (0, _presentationUtil.openLazyFlyout)({
        core: coreStart,
        parentApi: context.embeddable,
        flyoutProps: {
          'data-test-subj': 'aiopsChangePointChartEmbeddableInitializer',
          'aria-labelledby': 'changePointConfig',
          focusedPanelId: context.embeddable.uuid
        },
        loadContent: async ({
          closeFlyout
        }) => {
          const {
            EmbeddableChangePointUserInput
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/change_point_chart/change_point_config_input')));
          return /*#__PURE__*/_react.default.createElement(EmbeddableChangePointUserInput, {
            coreStart: coreStart,
            pluginStart: pluginStart,
            onConfirm: initialState => {
              presentationContainerParent.addNewPanel({
                panelType: _constants.EMBEDDABLE_CHANGE_POINT_CHART_TYPE,
                serializedState: {
                  rawState: initialState
                }
              });
              closeFlyout();
            },
            onCancel: closeFlyout,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 73,
              columnNumber: 13
            }
          });
        }
      });
    }
  };
}