"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDefaultSearchQuery = exports.getDefaultAiOpsListState = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlQueryUtils = require("@kbn/ml-query-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultSearchQuery = {
  match_all: {}
};
const isDefaultSearchQuery = arg => {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['match_all']);
};
exports.isDefaultSearchQuery = isDefaultSearchQuery;
const getDefaultAiOpsListState = overrides => ({
  searchString: '',
  searchQuery: defaultSearchQuery,
  searchQueryLanguage: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
  filters: [],
  ...overrides
});
exports.getDefaultAiOpsListState = getDefaultAiOpsListState;