"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValuesDescending = getValuesDescending;
var _get_value_counts = require("./get_value_counts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getValuesDescending(df, field) {
  const valueCounts = (0, _get_value_counts.getValueCounts)(df, field);
  const keys = Object.keys(valueCounts);
  return keys.sort((a, b) => {
    return valueCounts[b] - valueCounts[a];
  });
}