"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantManagementSelectionPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _ui_setting_keys = require("../common/ui_setting_keys");
var _classic_setting = require("./src/settings/classic_setting");
var _ai_assistant_type = require("../common/ai_assistant_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class AIAssistantManagementSelectionPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = initializerContext.config.get();
  }
  setup(core, plugins) {
    var _plugins$features;
    core.capabilities.registerProvider(() => {
      return {
        management: {
          ai: {
            aiAssistantManagementSelection: true,
            observabilityAiAssistantManagement: true,
            securityAiAssistantManagement: true
          }
        }
      };
    });
    (_plugins$features = plugins.features) === null || _plugins$features === void 0 ? void 0 : _plugins$features.registerKibanaFeature({
      id: 'aiAssistantManagementSelection',
      name: _i18n.i18n.translate('aiAssistantManagementSelection.featureRegistry.featureName', {
        defaultMessage: 'AI Assistant Settings'
      }),
      order: 8600,
      app: [],
      category: _server.DEFAULT_APP_CATEGORIES.management,
      management: {
        ai: ['aiAssistantManagementSelection', 'securityAiAssistantManagement', 'observabilityAiAssistantManagement']
      },
      minimumLicense: 'enterprise',
      privileges: {
        all: {
          management: {
            ai: ['aiAssistantManagementSelection', 'securityAiAssistantManagement', 'observabilityAiAssistantManagement']
          },
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        },
        read: {
          management: {
            ai: ['aiAssistantManagementSelection', 'securityAiAssistantManagement', 'observabilityAiAssistantManagement']
          },
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        }
      }
    });
    this.registerUiSettings(core, plugins);
    return {};
  }
  registerUiSettings(core, plugins) {
    const {
      cloud
    } = plugins;
    const serverlessProjectType = cloud === null || cloud === void 0 ? void 0 : cloud.serverless.projectType;

    // Do not register the setting in a serverless project
    if (!serverlessProjectType) {
      var _this$config$preferre;
      core.uiSettings.register({
        [_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY]: {
          ..._classic_setting.classicSetting,
          value: (_this$config$preferre = this.config.preferredAIAssistantType) !== null && _this$config$preferre !== void 0 ? _this$config$preferre : _ai_assistant_type.AIAssistantType.Default
        }
      });
    }
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.AIAssistantManagementSelectionPlugin = AIAssistantManagementSelectionPlugin;