"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllConnectorsRoute = void 0;
var _transforms = require("./transforms");
var _common = require("../../../../common");
var _verify_access_and_context = require("../../verify_access_and_context");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllConnectorsRoute = (router, licenseState) => {
  router.get({
    path: `${_common.BASE_ACTION_API_PATH}/connectors`,
    security: _constants.DEFAULT_ACTION_ROUTE_SECURITY,
    options: {
      access: 'public',
      summary: `Get all connectors`,
      tags: ['oas-tag:connectors']
      // description:
      //   'You must have `read` privileges for the **Actions and Connectors** feature in the **Management** section of the Kibana feature privileges.',
    },
    validate: {}
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const actionsClient = (await context.actions).getActionsClient();
    const result = await actionsClient.getAll();
    const responseBody = (0, _transforms.transformGetAllConnectorsResponseV2)(result);
    return res.ok({
      body: responseBody
    });
  })));
};
exports.getAllConnectorsRoute = getAllConnectorsRoute;