"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ENDPOINT_SECURITY_SUB_ACTIONS_EXECUTE_PRIVILEGE = exports.ENDPOINT_SECURITY_EXECUTE_PRIVILEGE = exports.ACTIONS_FEATURE = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _i18n = require("@kbn/i18n");
var _saved_objects = require("./constants/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENDPOINT_SECURITY_EXECUTE_PRIVILEGE_API_TAG = 'actions:execute-endpoint-security-connectors';
const ENDPOINT_SECURITY_EXECUTE_PRIVILEGE = exports.ENDPOINT_SECURITY_EXECUTE_PRIVILEGE = `api:${ENDPOINT_SECURITY_EXECUTE_PRIVILEGE_API_TAG}`;
const ENDPOINT_SECURITY_SUB_ACTIONS_EXECUTE_PRIVILEGE = exports.ENDPOINT_SECURITY_SUB_ACTIONS_EXECUTE_PRIVILEGE = `api:actions:execute-endpoint-security-sub-actions`;

/**
 * The order of appearance in the feature privilege page
 * under the management section.
 */
const FEATURE_ORDER = 3000;
const ACTIONS_FEATURE = exports.ACTIONS_FEATURE = {
  id: 'actions',
  name: _i18n.i18n.translate('xpack.actions.featureRegistry.actionsFeatureName', {
    defaultMessage: 'Actions and Connectors'
  }),
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.management,
  app: [],
  order: FEATURE_ORDER,
  management: {
    insightsAndAlerting: ['triggersActions', 'triggersActionsConnectors']
  },
  privileges: {
    all: {
      app: [],
      api: [],
      catalogue: [],
      management: {
        insightsAndAlerting: ['triggersActions', 'triggersActionsConnectors']
      },
      savedObject: {
        all: [_saved_objects.ACTION_SAVED_OBJECT_TYPE, _saved_objects.ACTION_TASK_PARAMS_SAVED_OBJECT_TYPE, _saved_objects.CONNECTOR_TOKEN_SAVED_OBJECT_TYPE],
        read: []
      },
      ui: ['show', 'execute', 'save', 'delete']
    },
    read: {
      app: [],
      api: [],
      catalogue: [],
      management: {
        insightsAndAlerting: ['triggersActions', 'triggersActionsConnectors']
      },
      savedObject: {
        // action execution requires 'read' over `actions`, but 'all' over `action_task_params`
        all: [_saved_objects.ACTION_TASK_PARAMS_SAVED_OBJECT_TYPE, _saved_objects.CONNECTOR_TOKEN_SAVED_OBJECT_TYPE],
        read: [_saved_objects.ACTION_SAVED_OBJECT_TYPE]
      },
      ui: ['show', 'execute']
    }
  },
  subFeatures: [{
    name: _i18n.i18n.translate('xpack.actions.featureRegistry.endpointSecuritySubFeatureName', {
      defaultMessage: 'Endpoint Security'
    }),
    description: _i18n.i18n.translate('xpack.actions.featureRegistry.endpointSecuritySubFeatureDescription', {
      defaultMessage: 'Includes: Sentinel One, CrowdStrike, Microsoft Defender for Endpoint'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: [ENDPOINT_SECURITY_EXECUTE_PRIVILEGE_API_TAG],
        id: 'endpoint_security_execute',
        name: _i18n.i18n.translate('xpack.actions.featureRegistry.endpointSecuritySubFeaturePrivilege', {
          defaultMessage: 'Execute'
        }),
        includeIn: 'all',
        savedObject: {
          all: [],
          read: []
        },
        ui: ['endpointSecurityExecute']
      }]
    }]
  }]
};