"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveScoped = resolveScoped;
const BindingScope_1 = require("../../binding/models/BindingScope");
const cacheResolvedValue_1 = require("./cacheResolvedValue");
const resolveBindingActivations_1 = require("./resolveBindingActivations");
function resolveScoped(getBinding, resolve) {
    return (params, arg) => {
        const binding = getBinding(arg);
        switch (binding.scope) {
            case BindingScope_1.bindingScopeValues.Singleton: {
                if (binding.cache.isRight) {
                    return binding.cache.value;
                }
                const resolvedValue = (0, resolveBindingActivations_1.resolveBindingActivations)(params, binding, resolve(params, arg));
                return (0, cacheResolvedValue_1.cacheResolvedValue)(binding, resolvedValue);
            }
            case BindingScope_1.bindingScopeValues.Request: {
                if (params.requestScopeCache.has(binding.id)) {
                    return params.requestScopeCache.get(binding.id);
                }
                const resolvedValue = (0, resolveBindingActivations_1.resolveBindingActivations)(params, binding, resolve(params, arg));
                params.requestScopeCache.set(binding.id, resolvedValue);
                return resolvedValue;
            }
            case BindingScope_1.bindingScopeValues.Transient:
                return (0, resolveBindingActivations_1.resolveBindingActivations)(params, binding, resolve(params, arg));
        }
    };
}
//# sourceMappingURL=resolveScoped.js.map