"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildDefaultManagedMetadata = buildDefaultManagedMetadata;
const ClassElementMetadataKind_1 = require("../models/ClassElementMetadataKind");
function buildDefaultManagedMetadata(kind, serviceIdentifier, options) {
    if (kind === ClassElementMetadataKind_1.ClassElementMetadataKind.multipleInjection) {
        return {
            chained: options?.chained ?? false,
            kind,
            name: undefined,
            optional: false,
            tags: new Map(),
            value: serviceIdentifier,
        };
    }
    else {
        return {
            kind,
            name: undefined,
            optional: false,
            tags: new Map(),
            value: serviceIdentifier,
        };
    }
}
//# sourceMappingURL=buildDefaultManagedMetadata.js.map