"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFilterButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _inner_text = require("../inner_text");
var _badge = require("../badge");
var _button_empty = require("../button/button_empty");
var _filter_button = require("./filter_button.styles");
var _button_group_button = require("../button/button_group/button_group_button");
var _button_group_button2 = require("../button/button_group/button_group_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "iconType", "iconSide", "color", "badgeColor", "hasActiveFilters", "numFilters", "numActiveFilters", "isToggle", "isDisabled", "isSelected", "type", "grow", "withNext", "textProps", "contentProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiFilterButton = exports.EuiFilterButton = function EuiFilterButton(_ref) {
  var children = _ref.children,
    className = _ref.className,
    iconType = _ref.iconType,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'right' : _ref$iconSide,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'text' : _ref$color,
    _ref$badgeColor = _ref.badgeColor,
    badgeColor = _ref$badgeColor === void 0 ? 'accent' : _ref$badgeColor,
    hasActiveFilters = _ref.hasActiveFilters,
    numFilters = _ref.numFilters,
    numActiveFilters = _ref.numActiveFilters,
    isToggle = _ref.isToggle,
    isDisabled = _ref.isDisabled,
    isSelected = _ref.isSelected,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    withNext = _ref.withNext,
    textProps = _ref.textProps,
    contentProps = _ref.contentProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var id = (0, _services.useGeneratedHtmlId)({
    prefix: 'filter-button'
  });
  var numFiltersDefined = numFilters != null; // != instead of !== to allow for null and undefined
  var numActiveFiltersDefined = !!numActiveFilters;
  var euiThemeContext = (0, _services.useEuiTheme)();
  var colorMode = euiThemeContext.colorMode;
  var isRefreshVariant = (0, _services.useEuiThemeRefreshVariant)('buttonVariant');

  // assumption about type of usage based on icon usage
  // requires manual override to apply correct aria attributes for more custom usages
  var isCollapsible = !isToggle && iconType === 'arrowDown';
  // NOTE: in Amsterdam `hasActiveFilters` applies selected styling while `isSelected` does not.
  // With Borealis this is more granular as EuiFilterButton now supports proper toggle buttons next to regular buttons
  var isExpanded = isCollapsible && (isSelected !== null && isSelected !== void 0 ? isSelected : hasActiveFilters);
  var styles = (0, _services.useEuiMemoizedStyles)(_filter_button.euiFilterButtonStyles);
  var focusColorStyles = (0, _services.useEuiMemoizedStyles)(_button_group_button2._compressedButtonFocusColors);
  var toggleVariantStyles = isRefreshVariant ? [isToggle && styles.buttonType.toggle, !isToggle && !isDisabled && focusColorStyles[color], !isToggle && styles.buttonType.default] : [isToggle && styles.buttonType.toggle];
  var cssStyles = [styles.euiFilterButton, !isRefreshVariant && withNext && styles.withNext, hasActiveFilters && styles.hasActiveFilters].concat(toggleVariantStyles);
  var wrapperStyles = (0, _services.useEuiMemoizedStyles)(_filter_button.euiFilterButtonWrapperStyles);
  var wrapperCssStyles = [wrapperStyles.wrapper, isRefreshVariant && withNext && styles.withNext, numFiltersDefined && styles.hasNotification, isToggle && wrapperStyles.hasToggle, !grow && styles.noGrow];
  var _useEuiMemoizedStyles = (0, _services.useEuiMemoizedStyles)(_filter_button.euiFilterButtonChildStyles),
    contentStyles = _useEuiMemoizedStyles.content,
    textStyles = _useEuiMemoizedStyles.text,
    notificationStyles = _useEuiMemoizedStyles.notification;
  var wrapperClasses = (0, _classnames.default)('euiFilterButton__wrapper');
  var classes = (0, _classnames.default)('euiFilterButton', {
    'euiFilterButton-isSelected': isSelected,
    'euiFilterButton-hasActiveFilters': hasActiveFilters,
    'euiFilterButton-hasNotification': numFiltersDefined,
    'euiFilterButton-isToggle': isRefreshVariant && isToggle
  }, className);

  /**
   * Badge
   */
  var showBadge = numFiltersDefined || numActiveFiltersDefined;
  var badgeCount = numActiveFilters || numFilters;
  var activeBadgeLabel = (0, _i18n.useEuiI18n)('euiFilterButton.filterBadgeActiveAriaLabel', '{count} active filters', {
    count: badgeCount
  });
  var availableBadgeLabel = (0, _i18n.useEuiI18n)('euiFilterButton.filterBadgeAvailableAriaLabel', '{count} available filters', {
    count: badgeCount
  });
  var badgeStyles = [notificationStyles.euiFilterButton__notification, isDisabled && notificationStyles.disabled];
  var badgeContent = (0, _react2.jsx)(_badge.EuiNotificationBadge, {
    className: "euiFilterButton__notification",
    css: badgeStyles,
    "aria-label": hasActiveFilters ? activeBadgeLabel : availableBadgeLabel,
    color: isDisabled || !hasActiveFilters ? 'subdued' : badgeColor,
    role: "marquee" // https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/marquee_role
  }, badgeCount);
  var badgeElement = showBadge && (isRefreshVariant ? (0, _react2.jsx)(_services.EuiThemeProvider, {
    colorMode: isToggle && isSelected ? 'INVERSE' : colorMode
  }, badgeContent) : badgeContent);

  /**
   * Text
   */
  var buttonTextClassNames = (0, _classnames.default)('euiFilterButton__text', {
    'euiFilterButton__text-hasNotification': showBadge
  }, textProps && textProps.className);
  var textCssStyles = [textStyles.euiFilterButton__text, showBadge && textStyles.hasNotification, textProps && textProps.css];
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    ref = _useInnerText2[0],
    innerText = _useInnerText2[1];
  var dataText = children && typeof children === 'string' ? children : innerText;
  var textContent = (0, _react2.jsx)("span", _extends({
    ref: ref,
    "data-text": dataText,
    title: dataText
  }, textProps, {
    className: buttonTextClassNames,
    css: textCssStyles
  }), children);

  /** Button element */
  var button = (0, _react2.jsx)(_button_empty.EuiButtonEmpty, _extends({
    className: classes,
    css: cssStyles,
    color: color,
    isDisabled: isDisabled,
    iconSide: iconSide,
    iconType: iconType,
    type: type,
    textProps: false,
    contentProps: _objectSpread(_objectSpread({}, contentProps), {}, {
      css: [contentStyles.euiFilterButton__content, iconType && contentStyles.hasIcon, contentProps === null || contentProps === void 0 ? void 0 : contentProps.css]
    }),
    "aria-expanded": isCollapsible ? isExpanded : undefined
  }, rest), textContent, badgeElement);
  var onToggleClick = function onToggleClick(e) {
    var _rest$onClick;
    rest === null || rest === void 0 || (_rest$onClick = rest.onClick) === null || _rest$onClick === void 0 || _rest$onClick.call(rest, e);
  };
  return (0, _react2.jsx)("div", {
    className: wrapperClasses,
    css: wrapperCssStyles
  }, isToggle && !isCollapsible ? (0, _react2.jsx)(_button_group_button.EuiButtonGroupButton, _extends({
    id: id,
    label: (0, _react2.jsx)(_react.default.Fragment, null, textContent, badgeElement),
    className: classes,
    css: cssStyles,
    color: color,
    isSelected: isSelected,
    size: "compressed",
    isDisabled: isDisabled,
    iconSide: iconSide,
    iconType: iconType,
    isIconOnly: false,
    type: type,
    textProps: false,
    contentProps: _objectSpread(_objectSpread({}, contentProps), {}, {
      css: [contentStyles.euiFilterButton__content, iconType && contentStyles.hasIcon, contentProps === null || contentProps === void 0 ? void 0 : contentProps.css]
    })
  }, rest, {
    onClick: onToggleClick
  })) : button);
};
EuiFilterButton.propTypes = {
  /**
     * Highlights active filters
     */
  hasActiveFilters: _propTypes.default.bool,
  /**
     * Pass the total number of filters available and it will
     * add a subdued notification badge showing the number
     */
  numFilters: _propTypes.default.number,
  /**
     * The number of active (selected) filters.
     * The value will be displayed as a bright notification badge.
     *
     * Accepted values are integers and percentages (e.g., 20%).
     * Passing other values is not supported and may break the layout.
     *
     * @example 10
     * @example '20%'
     */
  numActiveFilters: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
     * Switches between toggle and regular button
     * @default false
     */
  isToggle: _propTypes.default.bool,
  /**
     * Applies a visual state to the button.
     * Automatically applies `aria-pressed` when used with `isToggle={true}`.
     * Otherwise applies `aria-expanded` when used with `isToggle={false}` and
     * `iconType="arrowDown"` as trigger button for e.g. a popover.
     */
  isSelected: _propTypes.default.bool,
  /**
     * Should the button grow to fill its container, best used for dropdown buttons
     */
  grow: _propTypes.default.bool,
  /**
     * Remove border after button, good for opposite filters
     */
  withNext: _propTypes.default.bool,
  /**
     * Change color of the counter badge
     */
  badgeColor: _propTypes.default.any,
  /**
     * Any of the named color palette options.
     *
     * Do not use the following colors for standalone buttons directly,
     * they exist to serve other components:
     *  - accent
     *  - warning
     */
  color: _propTypes.default.any
};