"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _sorting = require("../../utils/sorting");
var _data_grid_cell_popover = require("./data_grid_cell_popover");
var _data_grid_cell = require("./data_grid_cell");
var _react2 = require("@emotion/react");
var _excluded = ["colIndex", "visibleRowIndex", "style", "schema", "schemaDetectors", "pagination", "columns", "leadingControlColumns", "trailingControlColumns", "visibleColCount", "columnWidths", "defaultColumnWidth", "renderCellValue", "cellContext", "renderCellPopover", "interactiveCellId", "setRowHeight", "rowHeightsOptions", "rowHeightUtils", "rowManager"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/**
 * A DRY wrapper used by both custom and virtualized grid cells.
 * It grabs context,  determines the type of cell being rendered
 * (e.g. control vs data cell), & sets shared props between all cells
 */
var CellWrapper = exports.CellWrapper = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var colIndex = _ref.colIndex,
    visibleRowIndex = _ref.visibleRowIndex,
    style = _ref.style,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    pagination = _ref.pagination,
    columns = _ref.columns,
    leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    visibleColCount = _ref.visibleColCount,
    columnWidths = _ref.columnWidths,
    defaultColumnWidth = _ref.defaultColumnWidth,
    renderCellValue = _ref.renderCellValue,
    cellContext = _ref.cellContext,
    renderCellPopover = _ref.renderCellPopover,
    interactiveCellId = _ref.interactiveCellId,
    setRowHeight = _ref.setRowHeight,
    rowHeightsOptions = _ref.rowHeightsOptions,
    rowHeightUtils = _ref.rowHeightUtils,
    rowManager = _ref.rowManager,
    rest = _objectWithoutProperties(_ref, _excluded);
  var popoverContext = (0, _react.useContext)(_data_grid_cell_popover.DataGridCellPopoverContext);
  var _useContext = (0, _react.useContext)(_sorting.DataGridSortedContext),
    getCorrectRowIndex = _useContext.getCorrectRowIndex;
  var isFirstColumn = colIndex === 0;
  var isLastColumn = colIndex === visibleColCount - 1;
  var isLeadingControlColumn = colIndex < leadingControlColumns.length;
  var isTrailingControlColumn = colIndex >= leadingControlColumns.length + columns.length;
  var datacolIndex = colIndex - leadingControlColumns.length;
  var column = columns[datacolIndex];
  var columnId = column === null || column === void 0 ? void 0 : column.id;
  var textTransform = (0, _react.useMemo)(function () {
    var _schemaDetectors$filt;
    return (_schemaDetectors$filt = schemaDetectors.filter(function (row) {
      return column !== null && column !== void 0 && column.schema ? (column === null || column === void 0 ? void 0 : column.schema) === row.type : columnId === row.type;
    })[0]) === null || _schemaDetectors$filt === void 0 ? void 0 : _schemaDetectors$filt.textTransform;
  }, [columnId, column === null || column === void 0 ? void 0 : column.schema, schemaDetectors]);
  var sharedCellProps = (0, _react.useMemo)(function () {
    var classes = (0, _classnames.default)(_defineProperty({
      'euiDataGridRowCell--firstColumn': isFirstColumn,
      'euiDataGridRowCell--lastColumn': isLastColumn,
      'euiDataGridRowCell--controlColumn': isLeadingControlColumn || isTrailingControlColumn
    }, "euiDataGridRowCell--".concat(textTransform), textTransform));
    return {
      rowIndex: getCorrectRowIndex(visibleRowIndex),
      visibleRowIndex: visibleRowIndex,
      colIndex: colIndex,
      interactiveCellId: interactiveCellId,
      className: classes,
      style: style,
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils,
      setRowHeight: isFirstColumn ? setRowHeight : undefined,
      rowManager: rowManager,
      popoverContext: popoverContext,
      pagination: pagination,
      cellContext: cellContext
    };
  }, [colIndex, setRowHeight, visibleRowIndex, getCorrectRowIndex, interactiveCellId, style, rowHeightsOptions, rowHeightUtils, rowManager, popoverContext, pagination, cellContext, isFirstColumn, isLastColumn, isLeadingControlColumn, isTrailingControlColumn, textTransform]);
  if (isLeadingControlColumn) {
    var leadingColumn = leadingControlColumns[colIndex];
    var id = leadingColumn.id,
      rowCellRender = leadingColumn.rowCellRender;
    return (0, _react2.jsx)(_data_grid_cell.EuiDataGridCell, _extends({}, sharedCellProps, {
      columnId: id,
      width: leadingColumn.width,
      renderCellValue: rowCellRender,
      isExpandable: false
    }, rest));
  } else if (isTrailingControlColumn) {
    var columnOffset = columns.length + leadingControlColumns.length;
    var trailingcolIndex = colIndex - columnOffset;
    var trailingColumn = trailingControlColumns[trailingcolIndex];
    var _id = trailingColumn.id,
      _rowCellRender = trailingColumn.rowCellRender;
    return (0, _react2.jsx)(_data_grid_cell.EuiDataGridCell, _extends({}, sharedCellProps, {
      columnId: _id,
      width: trailingColumn.width,
      renderCellValue: _rowCellRender,
      isExpandable: false
    }, rest));
  } else {
    // this is a normal data cell
    var columnType = schema[columnId] ? schema[columnId].columnType : null;
    var isExpandable = (column === null || column === void 0 ? void 0 : column.isExpandable) !== undefined ? column === null || column === void 0 ? void 0 : column.isExpandable : true;
    var width = columnWidths[columnId] || defaultColumnWidth;
    return (0, _react2.jsx)(_data_grid_cell.EuiDataGridCell, _extends({}, sharedCellProps, {
      columnId: columnId,
      column: column,
      columnType: columnType,
      width: width || undefined,
      renderCellValue: renderCellValue,
      renderCellPopover: renderCellPopover,
      interactiveCellId: interactiveCellId,
      isExpandable: isExpandable
    }, rest));
  }
});
CellWrapper.displayName = 'CellWrapper';