"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.valueGetterFunction = valueGetterFunction;
exports.getShapeViewModel = getShapeViewModel;
const viewmodel_1 = require("./viewmodel");
const canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
const config_1 = require("../config");
const group_by_rollup_1 = require("../utils/group_by_rollup");
function rawTextGetter(layers) {
    return (node) => {
        const accessorFn = layers[node[group_by_rollup_1.DEPTH_KEY] - 1]?.nodeLabel || ((d) => d);
        return `${accessorFn(node.dataName)}`;
    };
}
function valueGetterFunction(valueGetter) {
    return typeof valueGetter === 'function' ? valueGetter : config_1.VALUE_GETTERS[valueGetter];
}
function getShapeViewModel(spec, parentDimensions, tree, backgroundStyle, style, panelModel) {
    return (0, canvas_text_bbox_calculator_1.withTextMeasure)((measureText) => {
        return (0, viewmodel_1.shapeViewModel)(measureText, spec, style, parentDimensions, rawTextGetter(spec.layers), valueGetterFunction(spec.valueGetter), tree, backgroundStyle, panelModel);
    });
}
//# sourceMappingURL=scenegraph.js.map