"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrilldownList = void 0;
var React = _interopRequireWildcard(require("react"));
var _drilldown_table = require("../../components/drilldown_table");
var _context = require("../context");
var _cloning_notification = require("./cloning_notification");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/drilldowns/drilldown_manager/containers/drilldown_list/drilldown_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FIVE_SECONDS = 5e3;
const DrilldownList = ({}) => {
  const drilldowns = (0, _context.useDrilldownManager)();
  const events = drilldowns.useEvents();
  const cloningNotificationCount = React.useMemo(() => !!drilldowns.lastCloneRecord && drilldowns.lastCloneRecord.time > Date.now() - FIVE_SECONDS ? drilldowns.lastCloneRecord.templateIds.length : 0,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  React.useEffect(() => {
    drilldowns.lastCloneRecord = null;
  });
  const notification = !!cloningNotificationCount && /*#__PURE__*/React.createElement(_cloning_notification.CloningNotification, {
    count: cloningNotificationCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, notification, /*#__PURE__*/React.createElement(_drilldown_table.DrilldownTable, {
    items: events,
    onDelete: drilldowns.onDelete,
    onEdit: id => {
      drilldowns.setRoute(['manage', id]);
    },
    onCopy: drilldowns.onCreateFromDrilldown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
};
exports.DrilldownList = DrilldownList;