"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConfigRoute = createConfigRoute;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createConfigRoute({
  logger,
  router,
  baseRoute,
  alertingConfig,
  getRulesClientWithRequest
}) {
  const path = `${baseRoute}/_config`;
  logger.debug(`registering triggers_actions_ui config route GET ${path}`);
  router.get({
    path,
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization as it uses the alerting client authorization.'
      }
    },
    validate: false,
    options: {
      access: 'internal'
    }
  }, handler);
  async function handler(_, req, res) {
    // Check that user has access to at least one rule type
    const rulesClient = await getRulesClientWithRequest(req);
    const ruleTypes = Array.from(await rulesClient.listRuleTypes());
    const {
      minimumScheduleInterval,
      maxScheduledPerMinute,
      isUsingSecurity
    } = alertingConfig(); // Only returns exposed config values

    if (ruleTypes.length > 0) {
      return res.ok({
        body: {
          minimumScheduleInterval,
          maxScheduledPerMinute,
          isUsingSecurity
        }
      });
    } else {
      return res.forbidden({
        body: {
          message: `Unauthorized to access config`
        }
      });
    }
  }
}