"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggersActionsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _data = require("./data");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_TRIGGERS_ACTIONS_UI_API_PATH = '/internal/triggers_actions_ui';
class TriggersActionsPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "data", void 0);
    this.logger = ctx.logger.get();
    this.data = (0, _data.getService)();
  }
  setup(core, plugins) {
    const router = core.http.createRouter();
    (0, _data.register)({
      logger: this.logger,
      data: this.data,
      router,
      baseRoute: BASE_TRIGGERS_ACTIONS_UI_API_PATH
    });
    (0, _routes.createHealthRoute)(this.logger, router, BASE_TRIGGERS_ACTIONS_UI_API_PATH, plugins.alerting !== undefined);
    (0, _routes.createConfigRoute)({
      logger: this.logger,
      router,
      baseRoute: BASE_TRIGGERS_ACTIONS_UI_API_PATH,
      alertingConfig: plugins.alerting.getConfig,
      getRulesClientWithRequest: async request => {
        const [, pluginStart] = await core.getStartServices();
        return pluginStart.alerting.getRulesClientWithRequest(request);
      }
    });
  }
  start() {
    return {
      data: this.data
    };
  }
}
exports.TriggersActionsPlugin = TriggersActionsPlugin;