"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeUnitLabel = getTimeUnitLabel;
var _i18n = require("@kbn/i18n");
var _constants = require("../../application/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTimeUnitLabel(timeUnit = _constants.TIME_UNITS.SECOND, timeValue = '0') {
  switch (timeUnit) {
    case _constants.TIME_UNITS.SECOND:
      return _i18n.i18n.translate('xpack.triggersActionsUI.timeUnits.secondLabel', {
        defaultMessage: '{timeValue, plural, one {second} other {seconds}}',
        values: {
          timeValue
        }
      });
    case _constants.TIME_UNITS.MINUTE:
      return _i18n.i18n.translate('xpack.triggersActionsUI.timeUnits.minuteLabel', {
        defaultMessage: '{timeValue, plural, one {minute} other {minutes}}',
        values: {
          timeValue
        }
      });
    case _constants.TIME_UNITS.HOUR:
      return _i18n.i18n.translate('xpack.triggersActionsUI.timeUnits.hourLabel', {
        defaultMessage: '{timeValue, plural, one {hour} other {hours}}',
        values: {
          timeValue
        }
      });
    case _constants.TIME_UNITS.DAY:
      return _i18n.i18n.translate('xpack.triggersActionsUI.timeUnits.dayLabel', {
        defaultMessage: '{timeValue, plural, one {day} other {days}}',
        values: {
          timeValue
        }
      });
  }
}