"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.WhenExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/common/expression_items/when.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WhenExpression = ({
  aggType,
  customAggTypesOptions,
  onChangeSelectedAggType,
  display = 'inline',
  popupPosition
}) => {
  const [aggTypePopoverOpen, setAggTypePopoverOpen] = (0, _react.useState)(false);
  const aggregationTypes = customAggTypesOptions !== null && customAggTypesOptions !== void 0 ? customAggTypesOptions : _constants.builtInAggregationTypes;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "whenExpression",
      description: _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.threshold.descriptionLabel', {
        defaultMessage: 'when'
      }),
      value: aggregationTypes[aggType].text,
      isActive: aggTypePopoverOpen,
      display: display === 'inline' ? 'inline' : 'columns',
      onClick: () => {
        setAggTypePopoverOpen(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }),
    isOpen: aggTypePopoverOpen,
    closePopover: () => {
      setAggTypePopoverOpen(false);
    },
    ownFocus: true,
    display: display === 'fullWidth' ? 'block' : 'inline-block',
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downLeft',
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ClosablePopoverTitle, {
    onClose: () => setAggTypePopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.common.expressionItems.threshold.popoverTitle",
    defaultMessage: "when",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "whenExpressionSelect",
    id: "aggTypeField",
    value: aggType,
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.threshold.aggTypeSelectAriaLabel', {
      defaultMessage: 'Aggregation type'
    }),
    onChange: e => {
      onChangeSelectedAggType(e.target.value);
      setAggTypePopoverOpen(false);
    },
    options: Object.values(aggregationTypes).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.WhenExpression = WhenExpression;