"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ThresholdExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _constants = require("../constants");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/common/expression_items/threshold.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ThresholdExpression = ({
  thresholdComparator,
  errors,
  onChangeSelectedThresholdComparator,
  onChangeSelectedThreshold,
  customComparators,
  display = 'inline',
  threshold = [],
  popupPosition,
  unit = ''
}) => {
  const comparators = customComparators !== null && customComparators !== void 0 ? customComparators : _constants.builtInComparators;
  const [alertThresholdPopoverOpen, setAlertThresholdPopoverOpen] = (0, _react.useState)(false);
  const [comparator, setComparator] = (0, _react.useState)(thresholdComparator);
  const [numRequiredThresholds, setNumRequiredThresholds] = (0, _react.useState)(comparators[thresholdComparator].requiredValues);
  const andThresholdText = _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.threshold.andLabel', {
    defaultMessage: 'AND'
  });
  (0, _react.useEffect)(() => {
    const updateThresholdValue = comparators[comparator].requiredValues !== numRequiredThresholds;
    if (updateThresholdValue) {
      const thresholdValues = threshold.slice(0, comparators[comparator].requiredValues);
      onChangeSelectedThreshold(thresholdValues);
      setNumRequiredThresholds(comparators[comparator].requiredValues);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [comparator]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "thresholdPopover",
      description: comparators[comparator].text,
      value: (threshold || []).slice(0, numRequiredThresholds).join(` ${andThresholdText} `) + unit,
      isActive: Boolean(alertThresholdPopoverOpen || errors.threshold0 && errors.threshold0.length || errors.threshold1 && errors.threshold1.length),
      onClick: () => {
        setAlertThresholdPopoverOpen(true);
      },
      display: display === 'inline' ? 'inline' : 'columns',
      isInvalid: errors.threshold0 && errors.threshold0.length || errors.threshold1 && errors.threshold1.length ? true : false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }),
    isOpen: alertThresholdPopoverOpen,
    closePopover: () => {
      setAlertThresholdPopoverOpen(false);
    },
    ownFocus: true,
    display: display === 'fullWidth' ? 'block' : 'inline-block',
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downLeft',
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ClosablePopoverTitle, {
    onClose: () => setAlertThresholdPopoverOpen(false),
    dataTestSubj: "thresholdPopoverTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, comparators[comparator].text)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "comparatorOptionsComboBox",
    value: comparator,
    onChange: e => {
      setComparator(e.target.value);
      onChangeSelectedThresholdComparator(e.target.value);
    },
    options: Object.values(comparators).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    }),
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.threshold.comparatorAriaLabel', {
      defaultMessage: 'Threshold comparator'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  })), Array.from(Array(numRequiredThresholds)).map((_notUsed, i) => {
    var _errors, _errors2;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `threshold${i}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 15
      }
    }, i > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "watcherThresholdWatchInBetweenComparatorText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 21
      }
    }, andThresholdText)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      isInvalid: Number((_errors = errors[`threshold${i}`]) === null || _errors === void 0 ? void 0 : _errors.length) > 0 || (0, _lodash.isNil)(threshold[i]),
      error: errors[`threshold${i}`],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": `alertThresholdInput${i}`,
      min: 0,
      value: !threshold || threshold[i] === undefined ? '' : threshold[i],
      isInvalid: Number((_errors2 = errors[`threshold${i}`]) === null || _errors2 === void 0 ? void 0 : _errors2.length) > 0 || (0, _lodash.isNil)(threshold[i]),
      onChange: e => {
        const {
          value
        } = e.target;
        const thresholdVal = value !== '' ? parseFloat(value) : undefined;
        const newThreshold = [...threshold];
        if (thresholdVal !== undefined) {
          newThreshold[i] = thresholdVal;
        } else {
          delete newThreshold[i];
        }
        onChangeSelectedThreshold(newThreshold);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 21
      }
    }))));
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ThresholdExpression = ThresholdExpression;